"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PanelHeader = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _flyout_header = require("../../shared/components/flyout_header");
var _flyout_header_tabs = require("../../shared/components/flyout_header_tabs");
var _alert_header_title = require("./components/alert_header_title");
var _event_header_title = require("./components/event_header_title");
var _context = require("../shared/context");
var _use_basic_data_from_details_data = require("../shared/hooks/use_basic_data_from_details_data");
var _tour_config = require("../../../common/components/guided_onboarding_tour/tour_config");
var _tour_step = require("../../../common/components/guided_onboarding_tour/tour_step");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PanelHeader = exports.PanelHeader = /*#__PURE__*/(0, _react.memo)(({
  selectedTabId,
  setSelectedTabId,
  tabs,
  ...flyoutHeaderProps
}) => {
  const {
    dataFormattedForFieldBrowser
  } = (0, _context.useDocumentDetailsContext)();
  const {
    isAlert
  } = (0, _use_basic_data_from_details_data.useBasicDataFromDetailsData)(dataFormattedForFieldBrowser);
  const onSelectedTabChanged = id => setSelectedTabId(id);
  const tourAnchor = (0, _react.useMemo)(() => isAlert ? {
    'tour-step': (0, _tour_config.getTourAnchor)(_tour_config.AlertsCasesTourSteps.reviewAlertDetailsFlyout, _tour_config.SecurityStepId.alertsCases)
  } : {}, [isAlert]);
  const renderTabs = tabs.map((tab, index) => isAlert && tab.id === 'overview' ? /*#__PURE__*/_react.default.createElement(_tour_step.GuidedOnboardingTourStep, {
    isTourAnchor: isAlert,
    step: _tour_config.AlertsCasesTourSteps.reviewAlertDetailsFlyout,
    tourId: _tour_config.SecurityStepId.alertsCases,
    key: index
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, (0, _extends2.default)({
    onClick: () => onSelectedTabChanged(tab.id),
    isSelected: tab.id === selectedTabId,
    key: index,
    "data-test-subj": tab['data-test-subj']
  }, tourAnchor), tab.name)) : /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    onClick: () => onSelectedTabChanged(tab.id),
    isSelected: tab.id === selectedTabId,
    key: index,
    "data-test-subj": tab['data-test-subj']
  }, tab.name));
  return /*#__PURE__*/_react.default.createElement(_flyout_header.FlyoutHeader, flyoutHeaderProps, isAlert ? /*#__PURE__*/_react.default.createElement(_alert_header_title.AlertHeaderTitle, null) : /*#__PURE__*/_react.default.createElement(_event_header_title.EventHeaderTitle, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_flyout_header_tabs.FlyoutHeaderTabs, null, renderTabs));
});
PanelHeader.displayName = 'PanelHeader';