"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InvestigationGuide = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _use_investigation_guide = require("../../shared/hooks/use_investigation_guide");
var _context = require("../../shared/context");
var _left = require("../../left");
var _test_ids = require("./test_ids");
var _use_navigate_to_left_panel = require("../../shared/hooks/use_navigate_to_left_panel");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Render either the investigation guide button that opens Investigation section in the left panel,
 * or a no-data message if investigation guide hasn't been set up on the rule
 */
const InvestigationGuide = () => {
  const {
    dataFormattedForFieldBrowser,
    isRulePreview
  } = (0, _context.useDocumentDetailsContext)();
  const {
    loading,
    error,
    basicAlertData,
    ruleNote
  } = (0, _use_investigation_guide.useInvestigationGuide)({
    dataFormattedForFieldBrowser
  });
  const {
    navigateToLeftPanel: goToInvestigationsTab,
    isEnabled: isLinkEnabled
  } = (0, _use_navigate_to_left_panel.useNavigateToLeftPanel)({
    tab: _left.LeftPanelInvestigationTab
  });
  const hasInvestigationGuide = (0, _react.useMemo)(() => !error && basicAlertData && basicAlertData.ruleId && ruleNote, [error, basicAlertData, ruleNote]);
  const content = (0, _react.useMemo)(() => {
    if (isRulePreview) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        iconType: "documentation",
        size: "s",
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.flyout.right.investigation.investigationGuide.previewTitle",
          defaultMessage: "Investigation guide"
        }),
        "aria-label": _i18n.i18n.translate('xpack.securitySolution.flyout.right.investigation.investigationGuide.previewAriaLabel', {
          defaultMessage: 'Investigation guide'
        })
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.right.investigation.investigationGuide.previewMessage",
        defaultMessage: "Investigation guide is not available in alert preview."
      }));
    }
    if (loading) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
        "data-test-subj": _test_ids.INVESTIGATION_GUIDE_LOADING_TEST_ID,
        contentAriaLabel: _i18n.i18n.translate('xpack.securitySolution.flyout.right.investigation.investigationGuide.investigationGuideLoadingAriaLabel', {
          defaultMessage: 'investigation guide'
        })
      });
    }
    if (hasInvestigationGuide && !isLinkEnabled) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        iconType: "documentation",
        size: "s",
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.flyout.right.investigation.investigationGuide.openFlyoutTitle",
          defaultMessage: "Investigation guide available"
        }),
        "aria-label": _i18n.i18n.translate('xpack.securitySolution.flyout.right.investigation.investigationGuide.openFlyoutAriaLabel', {
          defaultMessage: 'Investigation guide available'
        })
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.right.investigation.investigationGuide.openFlyoutMessage",
        defaultMessage: "Open alert details to access investigation guides."
      }));
    }
    if (hasInvestigationGuide) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        onClick: goToInvestigationsTab,
        iconType: "documentation",
        size: "s",
        fullWidth: true,
        "data-test-subj": _test_ids.INVESTIGATION_GUIDE_BUTTON_TEST_ID,
        "aria-label": _i18n.i18n.translate('xpack.securitySolution.flyout.right.investigation.investigationGuide.investigationGuideButtonAriaLabel', {
          defaultMessage: 'Show investigation guide'
        })
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.right.investigation.investigationGuide.investigationGuideButtonLabel",
        defaultMessage: "Show investigation guide"
      }));
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      iconType: "documentation",
      size: "s",
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.right.investigation.investigationGuide.noDataTitle",
        defaultMessage: "Investigation guide"
      }),
      "aria-label": _i18n.i18n.translate('xpack.securitySolution.flyout.right.investigation.investigationGuide.noDataAriaLabel', {
        defaultMessage: 'Investigation guide'
      })
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.right.investigation.investigationGuide.noDataDescription",
      defaultMessage: "There's no investigation guide for this rule."
    }));
  }, [isRulePreview, loading, hasInvestigationGuide, isLinkEnabled, goToInvestigationsTab]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": _test_ids.INVESTIGATION_GUIDE_TEST_ID
  }, content);
};
exports.InvestigationGuide = InvestigationGuide;
InvestigationGuide.displayName = 'InvestigationGuideButton';