"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivilegedUserMonitoringSampleDashboard = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _header_section = require("../../../../../common/components/header_section");
var _get_lens_attributes = require("./get_lens_attributes");
var _use_columns = require("./use_columns");
var _constants = require("./constants");
var _esql_data_generation = require("./esql_data_generation");
var _esql_dashboard_panel = require("../esql_dashboard_panel/esql_dashboard_panel");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PrivilegedUserMonitoringSampleDashboardComponent = () => {
  const columns = (0, _use_columns.useColumns)();
  const esqlSource = (0, _react.useMemo)(() => (0, _esql_data_generation.generateESQLSource)(), []); // It needs to be memoized to avoid re-generating source data on every render
  const bucketTimerange = (0, _react.useMemo)(() => (0, _esql_data_generation.getBucketTimeRange)(), []);
  const generateTableQuery = (0, _react.useMemo)(() => (0, _esql_data_generation.generateListESQLQuery)(esqlSource), [esqlSource]);
  const generateVisualizationQuery = (0, _react.useMemo)(() => (0, _esql_data_generation.generateVisualizationESQLQuery)(esqlSource), [esqlSource]);
  const stackByOptions = _constants.GRANTED_RIGHTS_STACK_BY_OPTIONS;
  const setSelectedChartOptionCallback = (0, _react.useCallback)(event => {
    var _stackByOptions$find;
    setSelectedStackByOption((_stackByOptions$find = stackByOptions.find(co => co.value === event.target.value)) !== null && _stackByOptions$find !== void 0 ? _stackByOptions$find : stackByOptions[0]);
  }, [stackByOptions]);
  const defaultStackByOption = stackByOptions[0];
  const [selectedStackByOption, setSelectedStackByOption] = (0, _react.useState)(defaultStackByOption);
  const title = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.sampleDashboard.grantedRights.title",
    defaultMessage: "Granted rights"
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false,
    "data-test-subj": "privMonSampleDashboard"
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    title: title,
    titleSize: "s",
    outerDirection: 'column'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    onChange: setSelectedChartOptionCallback,
    options: _constants.GRANTED_RIGHTS_STACK_BY_OPTIONS,
    prepend: _i18n.i18n.translate('xpack.securitySolution.genericDashboard.stackBy.label', {
      defaultMessage: 'Stack by'
    }),
    value: selectedStackByOption === null || selectedStackByOption === void 0 ? void 0 : selectedStackByOption.value
  })), /*#__PURE__*/_react.default.createElement(_esql_dashboard_panel.EsqlDashboardPanel, {
    title: title,
    timerange: bucketTimerange,
    stackByField: selectedStackByOption.value,
    getLensAttributes: _get_lens_attributes.getLensAttributes,
    generateVisualizationQuery: generateVisualizationQuery,
    generateTableQuery: generateTableQuery,
    columns: columns,
    pageSize: _constants.PAGE_SIZE
  }));
};
const PrivilegedUserMonitoringSampleDashboard = exports.PrivilegedUserMonitoringSampleDashboard = /*#__PURE__*/_react.default.memo(PrivilegedUserMonitoringSampleDashboardComponent);