"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInitRiskEngineMutation = exports.INIT_RISK_ENGINE_STATUS_KEY = void 0;
var _reactQuery = require("@kbn/react-query");
var _api = require("../api");
var _use_risk_engine_status = require("./use_risk_engine_status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INIT_RISK_ENGINE_STATUS_KEY = exports.INIT_RISK_ENGINE_STATUS_KEY = ['POST', 'INIT_RISK_ENGINE'];
const useInitRiskEngineMutation = options => {
  const invalidateRiskEngineStatusQuery = (0, _use_risk_engine_status.useInvalidateRiskEngineStatusQuery)();
  const {
    initRiskEngine
  } = (0, _api.useEntityAnalyticsRoutes)();
  return (0, _reactQuery.useMutation)(() => initRiskEngine(), {
    ...options,
    mutationKey: INIT_RISK_ENGINE_STATUS_KEY,
    onSettled: (...args) => {
      invalidateRiskEngineStatusQuery();
      if (options !== null && options !== void 0 && options.onSettled) {
        options.onSettled(...args);
      }
    }
  });
};
exports.useInitRiskEngineMutation = useInitRiskEngineMutation;