"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGroupTakeActionsItems = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _store = require("../../../common/store");
var _use_start_transaction = require("../../../common/lib/apm/use_start_transaction");
var _use_app_toasts = require("../../../common/hooks/use_app_toasts");
var _constants = require("../../../common/lib/apm/constants");
var _update_alerts = require("../../../common/components/toolbar/bulk_actions/update_alerts");
var _translations = require("../../../common/components/toolbar/bulk_actions/translations");
var _translations2 = require("../../../common/translations");
var _types = require("../../../../common/types");
var _use_selector = require("../../../common/hooks/use_selector");
var i18n = _interopRequireWildcard(require("../translations"));
var _telemetry = require("../../../common/lib/telemetry");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTelemetryEvent = {
  groupedAlertsTakeAction: ({
    tableId,
    groupNumber,
    status
  }) => `alerts_table_${tableId}_group-${groupNumber}_mark-${status}`
};
/**
 * Hook returning a set of action items to be accessed when users click on the Take actions button displayed at the grouping alerts table group level.
 * Currently the action returned are: mark as opened, mark as acknowledged or mark as closed.
 * The hook is used in the alerts page, the rule details page and the entity analytics top risk score section.
 */
const useGroupTakeActionsItems = ({
  currentStatus,
  showAlertStatusActions = true
}) => {
  const {
    addSuccess,
    addError,
    addWarning
  } = (0, _use_app_toasts.useAppToasts)();
  const {
    startTransaction
  } = (0, _use_start_transaction.useStartTransaction)();
  const getGlobalQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalQuery(), []);
  const globalQueries = (0, _use_selector.useDeepEqualSelector)(getGlobalQuerySelector);
  const {
    services: {
      telemetry
    }
  } = (0, _public.useKibana)();
  const refetchQuery = (0, _react.useCallback)(() => {
    globalQueries.forEach(q => q.refetch && q.refetch());
  }, [globalQueries]);
  const reportAlertsGroupingTakeActionClick = (0, _react.useCallback)(params => {
    telemetry.reportEvent(_telemetry.AlertsEventTypes.AlertsGroupingTakeAction, params);
  }, [telemetry]);
  const onAlertStatusUpdateSuccess = (0, _react.useCallback)((updated, conflicts, newStatus) => {
    if (conflicts > 0) {
      // Partial failure
      addWarning({
        title: (0, _translations2.UPDATE_ALERT_STATUS_FAILED)(conflicts),
        text: (0, _translations2.UPDATE_ALERT_STATUS_FAILED_DETAILED)(updated, conflicts)
      });
    } else {
      let title;
      switch (newStatus) {
        case 'closed':
          title = i18n.CLOSED_ALERT_SUCCESS_TOAST(updated);
          break;
        case 'open':
          title = i18n.OPENED_ALERT_SUCCESS_TOAST(updated);
          break;
        case 'acknowledged':
          title = i18n.ACKNOWLEDGED_ALERT_SUCCESS_TOAST(updated);
      }
      addSuccess({
        title
      });
    }
    refetchQuery();
  }, [addSuccess, addWarning, refetchQuery]);
  const onAlertStatusUpdateFailure = (0, _react.useCallback)((newStatus, error) => {
    let title;
    switch (newStatus) {
      case 'closed':
        title = i18n.CLOSED_ALERT_FAILED_TOAST;
        break;
      case 'open':
        title = i18n.OPENED_ALERT_FAILED_TOAST;
        break;
      case 'acknowledged':
        title = i18n.ACKNOWLEDGED_ALERT_FAILED_TOAST;
    }
    addError(error.message, {
      title
    });
    refetchQuery();
  }, [addError, refetchQuery]);
  const onClickUpdate = (0, _react.useCallback)(async ({
    groupNumber,
    query,
    status,
    tableId,
    selectedGroup
  }) => {
    if (query) {
      startTransaction({
        name: _constants.APM_USER_INTERACTIONS.BULK_QUERY_STATUS_UPDATE
      });
    } else {
      startTransaction({
        name: _constants.APM_USER_INTERACTIONS.STATUS_UPDATE
      });
    }
    (0, _telemetry.track)(_telemetry.METRIC_TYPE.CLICK, getTelemetryEvent.groupedAlertsTakeAction({
      tableId,
      groupNumber,
      status
    }));
    reportAlertsGroupingTakeActionClick({
      tableId,
      groupNumber,
      status,
      groupByField: selectedGroup
    });
    try {
      var _response$updated, _response$version_con;
      const response = await (0, _update_alerts.updateAlertStatus)({
        status,
        query: query ? JSON.parse(query) : {}
      });
      onAlertStatusUpdateSuccess((_response$updated = response.updated) !== null && _response$updated !== void 0 ? _response$updated : 0, (_response$version_con = response.version_conflicts) !== null && _response$version_con !== void 0 ? _response$version_con : 0, status);
    } catch (error) {
      onAlertStatusUpdateFailure(status, error);
    }
  }, [startTransaction, reportAlertsGroupingTakeActionClick, onAlertStatusUpdateSuccess, onAlertStatusUpdateFailure]);
  return (0, _react.useMemo)(() => ({
    query,
    tableId,
    groupNumber,
    selectedGroup
  }) => {
    const actionItems = [];
    if (!showAlertStatusActions) {
      return actionItems;
    }
    if (currentStatus && currentStatus.length === 1) {
      const singleStatus = currentStatus[0];
      if (singleStatus !== _types.FILTER_OPEN) {
        actionItems.push(/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
          key: "open",
          "data-test-subj": "open-alert-status",
          onClick: () => onClickUpdate({
            groupNumber,
            query,
            selectedGroup,
            status: _types.FILTER_OPEN,
            tableId
          })
        }, _translations.BULK_ACTION_OPEN_SELECTED));
      }
      if (singleStatus !== _types.FILTER_ACKNOWLEDGED) {
        actionItems.push(/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
          key: "acknowledge",
          "data-test-subj": "acknowledged-alert-status",
          onClick: () => onClickUpdate({
            groupNumber,
            query,
            selectedGroup,
            status: _types.FILTER_ACKNOWLEDGED,
            tableId
          })
        }, _translations.BULK_ACTION_ACKNOWLEDGED_SELECTED));
      }
      if (singleStatus !== _types.FILTER_CLOSED) {
        actionItems.push(/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
          key: "close",
          "data-test-subj": "close-alert-status",
          onClick: () => onClickUpdate({
            groupNumber,
            query,
            selectedGroup,
            status: _types.FILTER_CLOSED,
            tableId
          })
        }, _translations.BULK_ACTION_CLOSE_SELECTED));
      }
    } else {
      const statusArr = {
        [_types.FILTER_OPEN]: _translations.BULK_ACTION_OPEN_SELECTED,
        [_types.FILTER_ACKNOWLEDGED]: _translations.BULK_ACTION_ACKNOWLEDGED_SELECTED,
        [_types.FILTER_CLOSED]: _translations.BULK_ACTION_CLOSE_SELECTED
      };
      Object.keys(statusArr).forEach(workflowStatus => actionItems.push(/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: workflowStatus,
        "data-test-subj": `${workflowStatus}-alert-status`,
        onClick: () => onClickUpdate({
          groupNumber,
          query,
          selectedGroup,
          status: workflowStatus,
          tableId
        })
      }, statusArr[workflowStatus])));
    }
    return actionItems;
  }, [currentStatus, onClickUpdate, showAlertStatusActions]);
};
exports.useGroupTakeActionsItems = useGroupTakeActionsItems;