"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BackfillStatusInfo = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getBackfillStatusColor(status) {
  switch (status) {
    case 'pending':
      return 'warning';
    case 'running':
      return 'success';
    default:
      return 'subdued';
  }
}
const BackfillStatusInfo = ({
  status
}) => {
  const capitalizedStatus = (0, _lodash.capitalize)(status);
  const color = getBackfillStatusColor(status);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: color
  }, capitalizedStatus);
};
exports.BackfillStatusInfo = BackfillStatusInfo;