"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.makeValidateRequiredField = makeValidateRequiredField;
var i18n = _interopRequireWildcard(require("./translations"));
var _utils = require("../utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function makeValidateRequiredField(parentFieldPath) {
  return function validateRequiredField(...args) {
    const [{
      value,
      path,
      form
    }] = args;
    const allRequiredFields = getAllRequiredFieldsValues(form, parentFieldPath);
    const isFieldNameUsedMoreThanOnce = allRequiredFields.filter(field => field.name === value.name).length > 1;
    if (isFieldNameUsedMoreThanOnce) {
      return {
        code: 'ERR_FIELD_FORMAT',
        path: `${path}.name`,
        message: i18n.FIELD_NAME_USED_MORE_THAN_ONCE(value.name)
      };
    }

    /* Allow empty rows. They are going to be removed before submission. */
    if (value.name.trim().length === 0 && value.type.trim().length === 0) {
      return;
    }
    if (value.name.trim().length === 0) {
      return {
        code: 'ERR_FIELD_MISSING',
        path: `${path}.name`,
        message: i18n.FIELD_NAME_REQUIRED
      };
    }
    if (value.type.trim().length === 0) {
      return {
        code: 'ERR_FIELD_MISSING',
        path: `${path}.type`,
        message: i18n.FIELD_TYPE_REQUIRED
      };
    }
  };
}
function getAllRequiredFieldsValues(form, parentFieldPath) {
  /*
    Getting values for required fields via flattened fields instead of using `getFormData`.
    This is because `getFormData` applies a serializer function to field values, which might update values.
    Using flattened fields allows us to get the original values before the serializer function is applied.
  */
  const flattenedFieldNames = (0, _utils.getFlattenedArrayFieldNames)(form, parentFieldPath);
  const fields = form.getFields();
  return flattenedFieldNames.map(fieldName => {
    var _fields$fieldName$val, _fields$fieldName;
    return (_fields$fieldName$val = (_fields$fieldName = fields[fieldName]) === null || _fields$fieldName === void 0 ? void 0 : _fields$fieldName.value) !== null && _fields$fieldName$val !== void 0 ? _fields$fieldName$val : {};
  });
}