"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RelatedIntegrationsHelpInfo = RelatedIntegrationsHelpInfo;
var _react = _interopRequireDefault(require("react"));
var _useToggle = _interopRequireDefault(require("react-use/lib/useToggle"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _kibana = require("../../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Theme doesn't expose width variables. Using provided size variables will require
 * multiplying it by another magic constant.
 *
 * 320px width looks
 * like a [commonly used width in EUI](https://github.com/search?q=repo%3Aelastic%2Feui%20320&type=code).
 */
const POPOVER_WIDTH = 320;
function RelatedIntegrationsHelpInfo() {
  const [isPopoverOpen, togglePopover] = (0, _useToggle.default)(false);
  const {
    docLinks
  } = (0, _kibana.useKibana)().services;
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "question",
    onClick: togglePopover,
    "aria-label": "Open help popover"
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: togglePopover
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    style: {
      width: POPOVER_WIDTH
    },
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.detectionEngine.ruleDescription.relatedIntegrations.fieldRelatedIntegrationsHelpText",
    defaultMessage: "Choose the {integrationsDocLink} this rule depends on, and correct if necessary each integration\u2019s version constraint in {semverLink} format. Only tilde, caret, and plain versions are supported, such as ~1.2.3, ^1.2.3, or 1.2.3.",
    values: {
      integrationsDocLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.securitySolution.createDetectionRules,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.detectionEngine.ruleDescription.relatedIntegrations.integrationsLink",
        defaultMessage: "integrations"
      })),
      semverLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://semver.org/",
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.detectionEngine.ruleDescription.relatedIntegrations.semanticVersionLink",
        defaultMessage: "semantic version"
      }))
    }
  })));
}