"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useActions = exports.VISUALIZATION_CONTEXT_MENU_TRIGGER = exports.INSPECT_ACTION = exports.DEFAULT_ACTIONS = void 0;
var _react = require("react");
var _public = require("@kbn/ui-actions-plugin/public");
var _kibana_react = require("../../lib/kibana/kibana_react");
var _use_add_to_existing_case = require("./use_add_to_existing_case");
var _use_add_to_new_case = require("./use_add_to_new_case");
var _use_save_to_library = require("./use_save_to_library");
var _types = require("./types");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_ACTIONS = exports.DEFAULT_ACTIONS = [_types.VisualizationContextMenuActions.inspect, _types.VisualizationContextMenuActions.addToNewCase, _types.VisualizationContextMenuActions.addToExistingCase, _types.VisualizationContextMenuActions.saveToLibrary, _types.VisualizationContextMenuActions.openInLens];
const INSPECT_ACTION = exports.INSPECT_ACTION = [_types.VisualizationContextMenuActions.inspect];
const VISUALIZATION_CONTEXT_MENU_TRIGGER = exports.VISUALIZATION_CONTEXT_MENU_TRIGGER = {
  id: 'VISUALIZATION_CONTEXT_MENU_TRIGGER'
};
const ACTION_DEFINITION = {
  [_types.VisualizationContextMenuActions.inspect]: {
    id: _types.VisualizationContextMenuActions.inspect,
    getDisplayName: () => _translations.INSPECT,
    getIconType: () => 'inspect',
    type: 'actionButton',
    order: 4
  },
  [_types.VisualizationContextMenuActions.addToNewCase]: {
    id: _types.VisualizationContextMenuActions.addToNewCase,
    getDisplayName: () => _translations.ADD_TO_NEW_CASE,
    getIconType: () => 'casesApp',
    type: 'actionButton',
    order: 3
  },
  [_types.VisualizationContextMenuActions.addToExistingCase]: {
    id: _types.VisualizationContextMenuActions.addToExistingCase,
    getDisplayName: () => _translations.ADD_TO_EXISTING_CASE,
    getIconType: () => 'casesApp',
    type: 'actionButton',
    order: 2
  },
  [_types.VisualizationContextMenuActions.saveToLibrary]: {
    id: _types.VisualizationContextMenuActions.saveToLibrary,
    getDisplayName: () => _translations.ADDED_TO_LIBRARY,
    getIconType: () => 'save',
    type: 'actionButton',
    order: 1
  },
  [_types.VisualizationContextMenuActions.openInLens]: {
    id: _types.VisualizationContextMenuActions.openInLens,
    getDisplayName: () => _translations.OPEN_IN_LENS,
    getIconType: () => 'visArea',
    type: 'actionButton',
    order: 0
  }
};
const useActions = ({
  attributes,
  lensMetadata,
  extraActions,
  inspectActionProps,
  timeRange,
  withActions = DEFAULT_ACTIONS
}) => {
  const {
    services
  } = (0, _kibana_react.useKibana)();
  const {
    lens: {
      navigateToPrefilledEditor,
      canUseEditor
    },
    topValuesPopover
  } = services;
  const onOpenInLens = (0, _react.useCallback)(() => {
    if (!timeRange || !attributes) {
      return;
    }
    navigateToPrefilledEditor({
      id: '',
      timeRange,
      attributes
    }, {
      openInNewTab: true
    });
  }, [attributes, navigateToPrefilledEditor, timeRange]);
  const {
    disabled: isAddToExistingCaseDisabled,
    onAddToExistingCaseClicked
  } = (0, _use_add_to_existing_case.useAddToExistingCase)({
    lensAttributes: attributes,
    timeRange,
    lensMetadata
  });
  const {
    onAddToNewCaseClicked,
    disabled: isAddToNewCaseDisabled
  } = (0, _use_add_to_new_case.useAddToNewCase)({
    timeRange,
    lensAttributes: attributes,
    lensMetadata
  });
  const {
    openSaveVisualizationFlyout,
    disableVisualizations
  } = (0, _use_save_to_library.useSaveToLibrary)({
    attributes
  });
  const allActions = (0, _react.useMemo)(() => [(0, _public.createAction)({
    ...ACTION_DEFINITION[_types.VisualizationContextMenuActions.inspect],
    execute: async () => {
      inspectActionProps.handleInspectClick();
    },
    disabled: inspectActionProps.isInspectButtonDisabled,
    isCompatible: async () => withActions.includes(_types.VisualizationContextMenuActions.inspect)
  }), (0, _public.createAction)({
    ...ACTION_DEFINITION[_types.VisualizationContextMenuActions.addToNewCase],
    execute: async () => {
      onAddToNewCaseClicked();
      topValuesPopover.closePopover();
    },
    disabled: isAddToNewCaseDisabled,
    isCompatible: async () => withActions.includes(_types.VisualizationContextMenuActions.addToNewCase)
  }), (0, _public.createAction)({
    ...ACTION_DEFINITION[_types.VisualizationContextMenuActions.addToExistingCase],
    execute: async () => {
      onAddToExistingCaseClicked();
    },
    disabled: isAddToExistingCaseDisabled,
    isCompatible: async () => withActions.includes(_types.VisualizationContextMenuActions.addToExistingCase),
    order: 2
  }), (0, _public.createAction)({
    ...ACTION_DEFINITION[_types.VisualizationContextMenuActions.saveToLibrary],
    execute: async () => {
      openSaveVisualizationFlyout();
    },
    disabled: disableVisualizations,
    isCompatible: async () => withActions.includes(_types.VisualizationContextMenuActions.saveToLibrary),
    order: 1
  }), (0, _public.createAction)({
    ...ACTION_DEFINITION[_types.VisualizationContextMenuActions.openInLens],
    execute: async () => {
      onOpenInLens();
    },
    isCompatible: async () => canUseEditor() && withActions.includes(_types.VisualizationContextMenuActions.openInLens),
    order: 0
  }), ...(extraActions !== null && extraActions !== void 0 ? extraActions : [])].map((a, i, totalActions) => {
    const order = Math.max(totalActions.length - (1 + i), 0);
    return {
      ...a,
      order
    };
  }), [canUseEditor, disableVisualizations, extraActions, inspectActionProps, isAddToExistingCaseDisabled, isAddToNewCaseDisabled, onAddToExistingCaseClicked, onAddToNewCaseClicked, onOpenInLens, openSaveVisualizationFlyout, withActions, topValuesPopover]);
  return allActions;
};
exports.useActions = useActions;