"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoNews = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var i18n = _interopRequireWildcard(require("../translations"));
var _kibana = require("../../../lib/kibana");
var _links = require("../../links");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NoNews = exports.NoNews = /*#__PURE__*/_react.default.memo(() => {
  var _capabilities$managem;
  const {
    getUrlForApp,
    navigateToApp,
    capabilities
  } = (0, _kibana.useKibana)().services.application;
  const canSeeAdvancedSettings = (_capabilities$managem = capabilities.management.kibana.settings) !== null && _capabilities$managem !== void 0 ? _capabilities$managem : false;
  const goToKibanaSettings = (0, _react.useCallback)(() => navigateToApp('management', {
    path: '/kibana/settings'
  }), [navigateToApp]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, canSeeAdvancedSettings ? i18n.NO_NEWS_MESSAGE_ADMIN : i18n.NO_NEWS_MESSAGE, canSeeAdvancedSettings && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ' ', /*#__PURE__*/_react.default.createElement(_links.LinkAnchor, {
    onClick: goToKibanaSettings,
    href: `${getUrlForApp('management', {
      path: '/kibana/settings'
    })}`
  }, i18n.ADVANCED_SETTINGS_LINK_TITLE), '.'));
});
NoNews.displayName = 'NoNews';