"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.links = void 0;
var _i18n = require("@kbn/i18n");
var _translations = require("../app/translations");
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const links = exports.links = {
  capabilities: [[`${_constants.SECURITY_FEATURE_ID}.show`, `${_constants.SECURITY_FEATURE_ID}.detections`]],
  globalNavPosition: 11,
  globalSearchKeywords: [_i18n.i18n.translate('xpack.securitySolution.appLinks.inventory', {
    defaultMessage: 'Inventory'
  })],
  uiSettingRequired: _constants.ENABLE_ASSET_INVENTORY_SETTING,
  id: _constants.SecurityPageName.assetInventory,
  path: _constants.ASSET_INVENTORY_PATH,
  title: _translations.INVENTORY
};