"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchGridData = useFetchGridData;
var _reactQuery = require("@kbn/react-query");
var _rxjs = require("rxjs");
var _ioTs = require("io-ts");
var _discoverUtils = require("@kbn/discover-utils");
var _cloudSecurityPosture = require("@kbn/cloud-security-posture");
var _react = require("react");
var _kibana = require("../../common/lib/kibana");
var _constants = require("../constants");
var _fetch_utils = require("./fetch_utils");
var _data_view_context = require("./data_view_context");
var _add_empty_data_filter = require("../utils/add_empty_data_filter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ASSET_INVENTORY_TABLE_RUNTIME_MAPPING_FIELDS = [_constants.ASSET_FIELDS.ENTITY_ID, _constants.ASSET_FIELDS.ENTITY_NAME];
const getAssetsQuery = ({
  query,
  sort
}, pageParam, indexPattern) => {
  var _query$bool$filter, _query$bool, _query$bool$must_not, _query$bool2;
  if (!indexPattern) {
    throw new Error('Index pattern is required');
  }
  return {
    index: indexPattern,
    sort: (0, _fetch_utils.getMultiFieldsSort)(sort),
    runtime_mappings: (0, _fetch_utils.getRuntimeMappingsFromSort)(ASSET_INVENTORY_TABLE_RUNTIME_MAPPING_FIELDS, sort),
    size: _constants.MAX_ASSETS_TO_LOAD,
    ignore_unavailable: true,
    query: {
      ...query,
      bool: {
        ...(query === null || query === void 0 ? void 0 : query.bool),
        filter: [...((_query$bool$filter = query === null || query === void 0 ? void 0 : (_query$bool = query.bool) === null || _query$bool === void 0 ? void 0 : _query$bool.filter) !== null && _query$bool$filter !== void 0 ? _query$bool$filter : [])],
        must_not: (0, _add_empty_data_filter.addEmptyDataFilterQuery)([...((_query$bool$must_not = query === null || query === void 0 ? void 0 : (_query$bool2 = query.bool) === null || _query$bool2 === void 0 ? void 0 : _query$bool2.must_not) !== null && _query$bool$must_not !== void 0 ? _query$bool$must_not : [])])
      }
    },
    ...(pageParam ? {
      from: pageParam
    } : {})
  };
};
function useFetchGridData(options) {
  const {
    data,
    notifications: {
      toasts
    }
  } = (0, _kibana.useKibana)().services;
  const {
    dataView
  } = (0, _data_view_context.useDataViewContext)();
  const dataViewIndexPattern = (0, _react.useMemo)(() => {
    return dataView === null || dataView === void 0 ? void 0 : dataView.getIndexPattern();
  }, [dataView]);
  return (0, _reactQuery.useInfiniteQuery)([_constants.QUERY_KEY_GRID_DATA, {
    params: options
  }], async ({
    pageParam
  }) => {
    const {
      rawResponse: {
        hits
      }
    } = await (0, _rxjs.lastValueFrom)(data.search.search({
      params: getAssetsQuery(options, pageParam, dataViewIndexPattern)
    }));
    return {
      page: hits.hits.map(hit => (0, _discoverUtils.buildDataTableRecord)(hit)),
      total: _ioTs.number.is(hits.total) ? hits.total : 0
    };
  }, {
    enabled: options.enabled && !!dataViewIndexPattern,
    keepPreviousData: true,
    onError: err => (0, _cloudSecurityPosture.showErrorToast)(toasts, err),
    getNextPageParam: (lastPage, allPages) => {
      if (lastPage.page.length < options.pageSize) {
        return undefined;
      }
      return allPages.length * options.pageSize;
    }
  });
}