"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Initializing = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _asset_inventory_title = require("../asset_inventory_title");
var _centered_wrapper = require("./centered_wrapper");
var _constants = require("../../constants");
var _use_add_integration_path = require("./hooks/use_add_integration_path");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Initializing = () => {
  const {
    addIntegrationPath,
    isLoading
  } = (0, _use_add_integration_path.useAddIntegrationPath)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_asset_inventory_title.AssetInventoryTitle, null), /*#__PURE__*/_react.default.createElement(_centered_wrapper.CenteredWrapper, null, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "data-test-subj": _constants.TEST_SUBJ_ONBOARDING_INITIALIZING,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingLogo, {
      logo: "logoSecurity",
      size: "xl"
    }),
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.assetInventory.onboarding.initializing.title",
      defaultMessage: "Discovering Your Assets"
    })),
    color: "plain",
    body: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.assetInventory.onboarding.initializing.description",
      defaultMessage: "We're currently analyzing your connected data sources to build a comprehensive inventory of your assets. This typically takes just a few minutes to complete. You'll be automatically redirected when your inventory is ready to explore."
    }),
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "fleetApp",
      size: "xl"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      alignItems: "flexStart",
      gutterSize: "none"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs"
    }, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.assetInventory.initializing.exploreTitle",
      defaultMessage: "Explore Asset Discovery Integrations"
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.assetInventory.initializing.exploreDescription",
      defaultMessage: "Discover assets across cloud, identity, and other environments for deeper visibility."
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      iconType: "plusInCircle",
      href: addIntegrationPath,
      isDisabled: isLoading
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.assetInventory.initializing.addIntegration",
      defaultMessage: "Add integration"
    }))))
  }))));
};
exports.Initializing = Initializing;