"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAddIntegrationPath = void 0;
var _common = require("@kbn/fleet-plugin/common");
var _kibana = require("../../../../common/lib/kibana");
var _use_get_asset_discovery_integration = require("./use_get_asset_discovery_integration");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook to get the path for adding an integration when clicking on "Add integration" button.
 * It checks if the Asset Discovery integration path is available, otherwise it defaults to the Integrations page path.
 */
const useAddIntegrationPath = () => {
  const {
    application
  } = (0, _kibana.useKibana)().services;
  const integrationsPath = application.getUrlForApp(_common.INTEGRATIONS_PLUGIN_ID);
  const assetDiscoveryIntegration = (0, _use_get_asset_discovery_integration.useAssetDiscoveryIntegration)();
  const addIntegrationPath = assetDiscoveryIntegration !== null && assetDiscoveryIntegration !== void 0 && assetDiscoveryIntegration.path ? assetDiscoveryIntegration.path : integrationsPath;
  return {
    addIntegrationPath,
    isLoading: assetDiscoveryIntegration.isLoading,
    isError: assetDiscoveryIntegration.isError,
    error: assetDiscoveryIntegration.error
  };
};
exports.useAddIntegrationPath = useAddIntegrationPath;