"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloudFormationCloudCredentialsGuide = exports.AwsCredentialsFormAgentless = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _compare = _interopRequireDefault(require("semver/functions/compare"));
var _valid = _interopRequireDefault(require("semver/functions/valid"));
var _constants = require("../constants");
var _aws_credentials_form_options = require("./aws_credentials_form_options");
var _utils = require("../utils");
var _aws_input_var_fields = require("./aws_input_var_fields");
var _aws_credentials_form = require("./aws_credentials_form");
var _constants2 = require("../../../constants");
var _constants3 = require("./constants");
var _use_kibana = require("../../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CLOUD_FORMATION_EXTERNAL_DOC_URL = 'https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-whatis-howdoesitwork.html';
const CloudFormationCloudCredentialsGuide = ({
  isOrganization,
  credentialType
}) => {
  var _credentialsTypeSteps, _credentialsTypeSteps2;
  const credentialsTypeSteps = {
    [_constants3.AWS_CREDENTIALS_TYPE.DIRECT_ACCESS_KEYS]: {
      intro: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.assetInventory.agentlessForm.cloudFormation.guide.description",
        defaultMessage: "Access keys are long-term credentials for an IAM user or the AWS account root user.\nUtilize AWS CloudFormation (a built-in AWS tool) or a series of manual steps to set up access. {learnMore}.",
        values: {
          learnMore: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: CLOUD_FORMATION_EXTERNAL_DOC_URL,
            target: "_blank",
            rel: "noopener nofollow noreferrer",
            "data-test-subj": "externalLink"
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.securitySolution.assetInventory.agentlessForm.cloudFormation.guide.learnMoreLinkText",
            defaultMessage: "Learn more about CloudFormation"
          }))
        }
      }),
      lastStep: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.assetInventory.agentlessForm.cloudFormation.steps.credentials",
        defaultMessage: "Copy {accessKeyId} and {secretAccessKey} then paste the credentials below",
        values: {
          accessKeyId: /*#__PURE__*/_react.default.createElement("strong", null, 'Access Key Id'),
          secretAccessKey: /*#__PURE__*/_react.default.createElement("strong", null, 'Secret Access Key')
        }
      })
    },
    [_constants3.AWS_CREDENTIALS_TYPE.CLOUD_CONNECTORS]: {
      intro: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.assetInventory.agentlessForm.cloudFormation.guide.description.cloudConnectors",
        defaultMessage: "To enable Cloud Asset Discovery, you launch an AWS CloudFormation stack that automatically creates an IAM role in your account. This role includes the necessary permissions and embeds a unique External ID\u2014generated during onboarding\u2014into its trust policy. The resulting Role ARN and External ID are then used by Cloud Asset Discovery to securely assume the role and access your AWS resources. Roles do not have standard long-term credentials such as passwords or access keys. {learnMore}.",
        values: {
          learnMore: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: CLOUD_FORMATION_EXTERNAL_DOC_URL,
            target: "_blank",
            rel: "noopener nofollow noreferrer",
            "data-test-subj": "externalLink"
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.securitySolution.assetInventory.agentlessForm.cloudFormation.guide.learnMoreLinkText",
            defaultMessage: "Learn more about CloudFormation"
          }))
        }
      }),
      lastStep: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.assetInventory.agentlessForm.cloudFormation.steps.credentials",
        defaultMessage: "Copy {role} and {external_id} then paste the role credentials below",
        values: {
          role: /*#__PURE__*/_react.default.createElement("strong", null, 'Role ARN'),
          external_id: /*#__PURE__*/_react.default.createElement("strong", null, 'External ID')
        }
      })
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, (_credentialsTypeSteps = credentialsTypeSteps[credentialType]) === null || _credentialsTypeSteps === void 0 ? void 0 : _credentialsTypeSteps.intro, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("ol", null, isOrganization ? /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.assetInventory.agentlessForm.cloudFormation.guide.steps.organizationLogin",
    defaultMessage: "Log in as an {admin} in the management account of the AWS Organization you want to onboard",
    values: {
      admin: /*#__PURE__*/_react.default.createElement("strong", null, 'admin')
    }
  })) : /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.assetInventory.agentlessForm.cloudFormation.guide.steps.singleLogin",
    defaultMessage: "Log in as an {admin} in the AWS account you want to onboard",
    values: {
      admin: /*#__PURE__*/_react.default.createElement("strong", null, 'admin')
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.assetInventory.agentlessForm.cloudFormation.guide.steps.launch",
    defaultMessage: "Click the {launchCloudFormation} button below.",
    values: {
      launchCloudFormation: /*#__PURE__*/_react.default.createElement("strong", null, 'Launch CloudFormation')
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.assetInventory.agentlessForm.cloudFormation.steps.region",
    defaultMessage: "(Optional) Change the {amazonRegion} in the upper right corner to the region you want to deploy your stack to",
    values: {
      amazonRegion: /*#__PURE__*/_react.default.createElement("strong", null, 'AWS region')
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.assetInventory.agentlessForm.cloudFormation.steps.accept",
    defaultMessage: "Tick the checkbox under {capabilities} in the opened CloudFormation stack review form: {acknowledge}",
    values: {
      acknowledge: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.assetInventory.agentlessForm.cloudFormation.steps.accept.acknowledge",
        defaultMessage: "I acknowledge that AWS CloudFormation might create IAM resources."
      })),
      capabilities: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.assetInventory.agentlessForm.cloudFormation.steps.accept.capabilties",
        defaultMessage: "capabilities"
      }))
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.assetInventory.agentlessForm.cloudFormation.steps.create",
    defaultMessage: "Click {createStack}.",
    values: {
      createStack: /*#__PURE__*/_react.default.createElement("strong", null, 'Create stack')
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.assetInventory.agentlessForm.cloudFormation.steps.stackStatus",
    defaultMessage: "Once  stack status is {createComplete} then click the Outputs tab",
    values: {
      createComplete: /*#__PURE__*/_react.default.createElement("strong", null, 'CREATE_COMPLETE')
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement("li", null, (_credentialsTypeSteps2 = credentialsTypeSteps[credentialType]) === null || _credentialsTypeSteps2 === void 0 ? void 0 : _credentialsTypeSteps2.lastStep))));
};

// TODO: Extract cloud connector logic into separate component
exports.CloudFormationCloudCredentialsGuide = CloudFormationCloudCredentialsGuide;
const AwsCredentialsFormAgentless = ({
  input,
  newPolicy,
  packageInfo,
  updatePolicy,
  hasInvalidRequiredVars,
  showCloudConnectors,
  setupTechnology,
  isEditPage
}) => {
  var _input$streams$0$vars, _input$streams, _input$streams$0$vars2, _input$streams$0$vars3, _getTemplateUrlFromPa;
  const {
    cloud
  } = (0, _use_kibana.useKibana)().services;
  const accountType = (_input$streams$0$vars = input === null || input === void 0 ? void 0 : (_input$streams = input.streams) === null || _input$streams === void 0 ? void 0 : (_input$streams$0$vars2 = _input$streams[0].vars) === null || _input$streams$0$vars2 === void 0 ? void 0 : (_input$streams$0$vars3 = _input$streams$0$vars2['aws.account_type']) === null || _input$streams$0$vars3 === void 0 ? void 0 : _input$streams$0$vars3.value) !== null && _input$streams$0$vars !== void 0 ? _input$streams$0$vars : _constants3.AWS_SINGLE_ACCOUNT;
  const awsCredentialsType = (0, _aws_credentials_form.getAgentlessCredentialsType)(input, !!showCloudConnectors);
  const documentationLink = _constants2.assetIntegrationDocsNavigation.awsGetStartedPath;

  // This should ony set the credentials after the initial render
  if (!(0, _utils.getAwsCredentialsType)(input)) {
    updatePolicy({
      ...(0, _utils.getAssetPolicy)(newPolicy, input.type, {
        'aws.credentials.type': {
          value: awsCredentialsType,
          type: 'text'
        },
        'aws.supports_cloud_connectors': {
          value: awsCredentialsType === _constants3.AWS_CREDENTIALS_TYPE.CLOUD_CONNECTORS,
          type: 'bool'
        }
      })
    });
  }
  const automationCredentialTemplate = (_getTemplateUrlFromPa = (0, _utils.getTemplateUrlFromPackageInfo)(packageInfo, input.policy_template, _constants.SUPPORTED_TEMPLATES_URL_FROM_PACKAGE_INFO_INPUT_VARS.CLOUD_FORMATION_CREDENTIALS)) === null || _getTemplateUrlFromPa === void 0 ? void 0 : _getTemplateUrlFromPa.replace(_constants.TEMPLATE_URL_ACCOUNT_TYPE_ENV_VAR, accountType);
  const cloudConnectorRemoteRoleTemplate = (0, _utils.getCloudConnectorRemoteRoleTemplate)({
    input,
    cloud,
    packageInfo
  });
  const cloudFormationSettings = {
    [_constants3.AWS_CREDENTIALS_TYPE.DIRECT_ACCESS_KEYS]: {
      accordianTitleLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, null, 'Steps to Generate AWS Account Credentials'),
      templateUrl: automationCredentialTemplate
    },
    [_constants3.AWS_CREDENTIALS_TYPE.CLOUD_CONNECTORS]: {
      accordianTitleLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, null, 'Steps to Generate Cloud Connection'),
      templateUrl: cloudConnectorRemoteRoleTemplate
    }
  };
  const isCloudFormationSupported = awsCredentialsType === _constants3.AWS_CREDENTIALS_TYPE.DIRECT_ACCESS_KEYS || awsCredentialsType === _constants3.AWS_CREDENTIALS_TYPE.CLOUD_CONNECTORS;
  const agentlessOptions = showCloudConnectors ? (0, _aws_credentials_form_options.getAwsCloudConnectorsCredentialsFormOptions)() : (0, _aws_credentials_form_options.getAwsAgentlessFormOptions)();
  const group = agentlessOptions[awsCredentialsType];
  const fields = (0, _aws_credentials_form_options.getInputVarsFields)(input, group.fields);
  const isOrganization = accountType === _constants3.AWS_ORGANIZATION_ACCOUNT;
  const isValidSemantic = (0, _valid.default)(packageInfo.version);
  const showCloudCredentialsButton = isValidSemantic ? (0, _compare.default)(packageInfo.version, _constants2.ASSET_INVENTORY_CLOUD_CREDENTIALS_PACKAGE_VERSION) >= 0 : false;
  const disabled = !!isEditPage && awsCredentialsType === _constants3.AWS_CREDENTIALS_TYPE.CLOUD_CONNECTORS && showCloudConnectors;
  const showCloudFormationAccordion = isCloudFormationSupported && showCloudCredentialsButton;
  const selectorOptions = () => {
    if (isEditPage && _constants3.AWS_CREDENTIALS_TYPE.CLOUD_CONNECTORS !== awsCredentialsType) {
      return (0, _aws_credentials_form_options.getAwsCredentialsFormAgentlessOptions)();
    }
    if (showCloudConnectors) {
      return (0, _aws_credentials_form_options.getAwsCloudConnectorsFormAgentlessOptions)();
    }
    return (0, _aws_credentials_form_options.getAwsCredentialsFormAgentlessOptions)();
  };
  const accordianTitleLink = showCloudFormationAccordion ? cloudFormationSettings[awsCredentialsType].accordianTitleLink : '';
  const templateUrl = showCloudFormationAccordion ? cloudFormationSettings[awsCredentialsType].templateUrl : '';
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_aws_credentials_form.AWSSetupInfoContent, {
    info: showCloudConnectors ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.assetInventory.awsIntegration.gettingStarted.setupInfoContentAgentlessCloudConnectors",
      defaultMessage: "Utilize AWS Access Keys or Cloud Connectors to set up and deploy Asset Discovery for assessing your AWS environment's assets. Refer to our {gettingStartedLink} guide for details.",
      values: {
        gettingStartedLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: documentationLink,
          target: "_blank"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.assetInventory.awsIntegration.gettingStarted.setupInfoContentLink",
          defaultMessage: "Getting Started"
        }))
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.assetInventory.awsIntegration.gettingStarted.setupInfoContentAgentless",
      defaultMessage: "Utilize AWS Access Keys to set up and deploy Asset Discovery for assessing your AWS environment's assets. Refer to our {gettingStartedLink} guide for details.",
      values: {
        gettingStartedLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: documentationLink,
          target: "_blank"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.assetInventory.awsIntegration.gettingStarted.setupInfoContentLink",
          defaultMessage: "Getting Started"
        }))
      }
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_aws_credentials_form.AwsCredentialTypeSelector, {
    label: _i18n.i18n.translate('xpack.securitySolution.assetInventory.awsIntegration.awsCredentialTypeSelectorLabelAgentless', {
      defaultMessage: 'Preferred method'
    }),
    type: awsCredentialsType,
    options: selectorOptions(),
    disabled: disabled,
    onChange: optionId => {
      updatePolicy((0, _utils.getAssetPolicy)(newPolicy, input.type, (0, _utils.getCloudCredentialVarsConfig)({
        setupTechnology,
        optionId,
        showCloudConnectors: !!showCloudConnectors,
        inputType: input.type
      })));
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), !showCloudCredentialsButton && isCloudFormationSupported && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.assetInventory.fleetIntegration.awsCloudCredentials.cloudFormationSupportedMessage",
    defaultMessage: "Launch Cloud Formation for Automated Credentials not supported in current integration version. Please upgrade to the latest version to enable Launch CloudFormation for automated credentials."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), showCloudFormationAccordion && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "cloudFormationAccordianInstructions",
    "data-test-subj": _constants2.TEST_SUBJ_AWS_CLOUD_FORMATION_ACCORDIAN,
    buttonContent: accordianTitleLink,
    paddingSize: "l"
  }, /*#__PURE__*/_react.default.createElement(CloudFormationCloudCredentialsGuide, {
    isOrganization: isOrganization,
    credentialType: awsCredentialsType
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "launchCloudFormationAgentlessButton",
    target: "_blank",
    iconSide: "left",
    iconType: "launch",
    href: templateUrl
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.assetInventory.agentlessForm.agentlessAWSCredentialsForm.cloudFormation.launchButton",
    defaultMessage: "Launch CloudFormation"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_aws_input_var_fields.AwsInputVarFields, {
    fields: fields,
    packageInfo: packageInfo,
    onChange: (key, value) => {
      updatePolicy((0, _utils.getAssetPolicy)(newPolicy, input.type, {
        [key]: {
          value
        }
      }));
    },
    hasInvalidRequiredVars: hasInvalidRequiredVars
  }), /*#__PURE__*/_react.default.createElement(_aws_credentials_form.ReadDocumentation, {
    url: documentationLink
  }));
};
exports.AwsCredentialsFormAgentless = AwsCredentialsFormAgentless;