"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FindAssetCriticalityRecordsResponse = exports.FindAssetCriticalityRecordsRequestQuery = void 0;
var _zod = require("@kbn/zod");
var _common = require("./common.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Asset Criticality List Schema
 *   version: 2023-10-31
 */

const FindAssetCriticalityRecordsRequestQuery = exports.FindAssetCriticalityRecordsRequestQuery = _zod.z.object({
  /**
   * The field to sort by.
   */
  sort_field: _zod.z.enum(['id_value', 'id_field', 'criticality_level', '@timestamp']).optional(),
  /**
   * The order to sort by.
   */
  sort_direction: _zod.z.enum(['asc', 'desc']).optional(),
  /**
   * The page number to return.
   */
  page: _zod.z.coerce.number().int().min(1).optional(),
  /**
   * The number of records to return per page.
   */
  per_page: _zod.z.coerce.number().int().min(1).max(1000).optional(),
  /**
   * The kuery to filter by.
   */
  kuery: _zod.z.string().optional()
});
const FindAssetCriticalityRecordsResponse = exports.FindAssetCriticalityRecordsResponse = _zod.z.object({
  records: _zod.z.array(_common.AssetCriticalityRecord),
  page: _zod.z.number().int().min(1),
  per_page: _zod.z.number().int().min(1).max(1000),
  total: _zod.z.number().int().min(0)
});