"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleResponseOsqueryAction = exports.RuleResponseEndpointAction = exports.RuleResponseAction = exports.ResponseActionTypesEnum = exports.ResponseActionTypes = exports.ResponseAction = exports.ProcessesParams = exports.OsqueryResponseAction = exports.OsqueryQuery = exports.OsqueryParamsCamelCase = exports.OsqueryParams = exports.EndpointResponseAction = exports.EcsMapping = exports.DefaultParams = void 0;
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Response Actions Schema
 *   version: not applicable
 */

const ResponseActionTypes = exports.ResponseActionTypes = _zod.z.enum(['.osquery', '.endpoint']);
const ResponseActionTypesEnum = exports.ResponseActionTypesEnum = ResponseActionTypes.enum;

/**
 * Map Osquery results columns or static values to Elastic Common Schema (ECS) fields. Example: "ecs_mapping": {"process.pid": {"field": "pid"}}
 */

const EcsMapping = exports.EcsMapping = _zod.z.object({}).catchall(_zod.z.object({
  field: _zod.z.string().optional(),
  value: _zod.z.union([_zod.z.string(), _zod.z.array(_zod.z.string())]).optional()
}));
const OsqueryQuery = exports.OsqueryQuery = _zod.z.object({
  /**
   * Query ID
   */
  id: _zod.z.string(),
  /**
   * Query to run
   */
  query: _zod.z.string(),
  ecs_mapping: EcsMapping.optional(),
  /**
   * Query version
   */
  version: _zod.z.string().optional(),
  platform: _zod.z.string().optional(),
  removed: _zod.z.boolean().optional(),
  snapshot: _zod.z.boolean().optional()
});
const OsqueryParams = exports.OsqueryParams = _zod.z.object({
  /**
   * To run a single query, use the query field and enter a SQL query. Example: "query": "SELECT * FROM processes;"
   */
  query: _zod.z.string().optional(),
  ecs_mapping: EcsMapping.optional(),
  queries: _zod.z.array(OsqueryQuery).optional(),
  /**
   * To specify a query pack, use the packId field. Example: "packId": "processes_elastic"
   */
  pack_id: _zod.z.string().optional(),
  /**
   * To run a saved query, use the saved_query_id field and specify the saved query ID. Example: "saved_query_id": "processes_elastic"
   */
  saved_query_id: _zod.z.string().optional(),
  /**
   * A timeout period, in seconds, after which the query will stop running. Overwriting the default timeout allows you to support queries that require more time to complete. The default and minimum supported value is 60. The maximum supported value is 900. Example: "timeout": 120.
   */
  timeout: _zod.z.number().optional()
});
const OsqueryParamsCamelCase = exports.OsqueryParamsCamelCase = _zod.z.object({
  query: _zod.z.string().optional(),
  ecsMapping: EcsMapping.optional(),
  queries: _zod.z.array(OsqueryQuery).optional(),
  packId: _zod.z.string().optional(),
  savedQueryId: _zod.z.string().optional(),
  timeout: _zod.z.number().optional()
});
const OsqueryResponseAction = exports.OsqueryResponseAction = _zod.z.object({
  action_type_id: _zod.z.literal('.osquery'),
  params: OsqueryParams
});
const RuleResponseOsqueryAction = exports.RuleResponseOsqueryAction = _zod.z.object({
  actionTypeId: _zod.z.literal('.osquery'),
  params: OsqueryParamsCamelCase
});
const DefaultParams = exports.DefaultParams = _zod.z.object({
  command: _zod.z.literal('isolate'),
  comment: _zod.z.string().optional()
});
const ProcessesParams = exports.ProcessesParams = _zod.z.object({
  /**
   * To run an endpoint response action, specify a value for the command field. Example: "command": "isolate"
   */
  command: _zod.z.enum(['kill-process', 'suspend-process']),
  /**
   * Add a note that explains or describes the action. You can find your comment in the response actions history log. Example: "comment": "Check processes"
   */
  comment: _zod.z.string().optional(),
  config: _zod.z.object({
    /**
     * Field to use instead of process.pid
     */
    field: _zod.z.string(),
    /**
     * Whether to overwrite field with process.pid
     */
    overwrite: _zod.z.boolean().optional().default(true)
  })
});
const EndpointResponseAction = exports.EndpointResponseAction = _zod.z.object({
  action_type_id: _zod.z.literal('.endpoint'),
  params: _zod.z.union([DefaultParams, ProcessesParams])
});
const RuleResponseEndpointAction = exports.RuleResponseEndpointAction = _zod.z.object({
  actionTypeId: _zod.z.literal('.endpoint'),
  params: _zod.z.union([DefaultParams, ProcessesParams])
});
const ResponseAction = exports.ResponseAction = _zod.z.union([OsqueryResponseAction, EndpointResponseAction]);
const RuleResponseAction = exports.RuleResponseAction = _zod.z.union([RuleResponseOsqueryAction, RuleResponseEndpointAction]);