"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CurlSearchCodeExample = exports.CurlIngestDataExample = exports.CurlCreateIndexExamples = exports.CURL_INFO = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CURL_INFO = exports.CURL_INFO = {
  id: 'curl',
  title: _i18n.i18n.translate('xpack.searchIndices.codingLanguages.curl', {
    defaultMessage: 'cURL'
  }),
  icon: 'curl.svg',
  codeBlockLanguage: 'shell'
};
const CurlCreateIndexExamples = exports.CurlCreateIndexExamples = {
  default: {
    createIndex: ({
      elasticsearchURL,
      apiKey,
      indexName
    }) => `curl -X PUT '${elasticsearchURL}/${indexName !== null && indexName !== void 0 ? indexName : _constants.INDEX_PLACEHOLDER}' \
--header 'Authorization: ApiKey ${apiKey !== null && apiKey !== void 0 ? apiKey : _constants.API_KEY_PLACEHOLDER}' \
--header 'Content-Type: application/json' \
--data-raw '{
  "mappings": {
    "properties":{
      "text":{
        "type":"text"
      }
    }
  }
}'`
  },
  dense_vector: {
    createIndex: ({
      elasticsearchURL,
      apiKey,
      indexName
    }) => `curl -X PUT '${elasticsearchURL}/${indexName !== null && indexName !== void 0 ? indexName : _constants.INDEX_PLACEHOLDER}' \
--header 'Authorization: ApiKey ${apiKey !== null && apiKey !== void 0 ? apiKey : _constants.API_KEY_PLACEHOLDER}' \
--header 'Content-Type: application/json' \
--data-raw '{
  "mappings": {
    "properties":{
      "vector":{
        "type": "dense_vector",
        "dims": 3
      },
      "text":{
        "type":"text"
      }
    }
  }
}'`
  },
  semantic: {
    createIndex: ({
      elasticsearchURL,
      apiKey,
      indexName
    }) => `curl -X PUT '${elasticsearchURL}/${indexName !== null && indexName !== void 0 ? indexName : _constants.INDEX_PLACEHOLDER}' \
--header 'Authorization: ApiKey ${apiKey !== null && apiKey !== void 0 ? apiKey : _constants.API_KEY_PLACEHOLDER}' \
--header 'Content-Type: application/json' \
--data-raw '{
  "mappings": {
    "properties":{
      "text":{
        "type":"semantic_text"
      }
    }
  }
}'`
  }
};
const CurlIngestDataExample = exports.CurlIngestDataExample = {
  ingestCommand: ({
    elasticsearchURL,
    apiKey,
    indexName,
    sampleDocuments
  }) => {
    let result = `curl -X POST "${elasticsearchURL}/_bulk?pretty" \
--header 'Authorization: ApiKey ${apiKey !== null && apiKey !== void 0 ? apiKey : _constants.API_KEY_PLACEHOLDER}' \
--header 'Content-Type: application/json' \
-d'`;
    sampleDocuments.forEach(document => {
      result += `
{ "index" : { "_index" : "${indexName}" } }
${JSON.stringify(document)}`;
    });
    result += "\n'";
    return result;
  },
  updateMappingsCommand: ({
    elasticsearchURL,
    apiKey,
    indexName,
    mappingProperties
  }) => `curl -X PUT "${elasticsearchURL}/${indexName}/_mapping" \
--header 'Authorization: ApiKey ${apiKey !== null && apiKey !== void 0 ? apiKey : _constants.API_KEY_PLACEHOLDER}' \
--header 'Content-Type: application/json' \
--data-raw '${JSON.stringify({
    properties: mappingProperties
  })}'`
};
const CurlSearchCodeExample = exports.CurlSearchCodeExample = {
  searchCommand: ({
    elasticsearchURL,
    apiKey,
    indexName,
    queryObject
  }) => `curl -X POST "${elasticsearchURL}/${indexName}/_search" \
--header 'Authorization: ApiKey ${apiKey !== null && apiKey !== void 0 ? apiKey : _constants.API_KEY_PLACEHOLDER}' \
--header 'Content-Type: application/json' \
--data-raw '${JSON.stringify(queryObject)}'`
};