"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssignFlyoutActionBar = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AssignFlyoutActionBar = ({
  resultCount,
  initiallyAssigned,
  pendingChanges,
  onReset,
  onSelectAll,
  onDeselectAll
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    css: styles
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.savedObjectsTagging.assignFlyout.actionBar.totalResultsLabel",
    defaultMessage: "{count, plural, one {1 saved object} other {# saved objects}}",
    values: {
      count: resultCount
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "tagMgt__actionBarDivider"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, pendingChanges > 0 ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.savedObjectsTagging.assignFlyout.actionBar.pendingChanges",
    defaultMessage: "{count} pending changes",
    values: {
      count: pendingChanges
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.savedObjectsTagging.assignFlyout.actionBar.currentlyAssigned",
    defaultMessage: "{count} currently assigned",
    values: {
      count: initiallyAssigned
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: onReset,
    "data-test-subj": "assignFlyout-resetButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.savedObjectsTagging.assignFlyout.actionBar.resetLabel",
    defaultMessage: "Reset"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: onSelectAll,
    "data-test-subj": "assignFlyout-selectAllButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.savedObjectsTagging.assignFlyout.actionBar.selectedAllLabel",
    defaultMessage: "Select all"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: onDeselectAll,
    "data-test-subj": "assignFlyout-deselectAllButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.savedObjectsTagging.assignFlyout.actionBar.deselectedAllLabel",
    defaultMessage: "Deselect all"
  }))))));
};
exports.AssignFlyoutActionBar = AssignFlyoutActionBar;
const styles = ({
  euiTheme
}) => (0, _react2.css)({
  marginTop: euiTheme.size.xs,
  '.tagMgt__actionBarDivider': {
    height: euiTheme.size.base,
    borderRight: euiTheme.border.thin
  }
});