"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertsGroupAggregations = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _constants = require("../../common/constants");
var _route_validation = require("./utils/route_validation");
var _types = require("../../common/types");
var _constants2 = require("../alert_data_client/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAlertsGroupAggregations = router => {
  router.post({
    path: `${_constants.BASE_RAC_ALERTS_API_PATH}/_group_aggregations`,
    validate: {
      body: (0, _route_validation.buildRouteValidation)(t.intersection([t.exact(t.type({
        ruleTypeIds: t.array(t.string),
        groupByField: t.string,
        aggregations: t.union([_types.alertsAggregationsSchema, t.undefined]),
        filters: t.union([t.array(_types.alertsGroupFilterSchema), t.undefined]),
        sort: t.union([t.array(t.object), t.undefined]),
        pageIndex: t.union([t.number, t.undefined]),
        pageSize: t.union([t.number, t.undefined])
      })), t.exact(t.partial({
        consumers: t.array(t.string)
      }))]))
    },
    security: {
      authz: {
        requiredPrivileges: ['rac']
      }
    },
    options: {
      access: 'internal'
    }
  }, async (context, request, response) => {
    const {
      ruleTypeIds,
      consumers,
      groupByField,
      aggregations,
      filters,
      sort,
      pageIndex = 0,
      pageSize = _constants2.DEFAULT_ALERTS_GROUP_BY_FIELD_SIZE
    } = request.body;
    try {
      const racContext = await context.rac;
      const alertsClient = await racContext.getAlertsClient();
      const alerts = await alertsClient.getGroupAggregations({
        ruleTypeIds,
        consumers,
        groupByField,
        aggregations,
        filters,
        sort: sort,
        pageIndex,
        pageSize
      });
      return response.ok({
        body: alerts
      });
    } catch (exc) {
      const err = (0, _securitysolutionEsUtils.transformError)(exc);
      const contentType = {
        'content-type': 'application/json'
      };
      const defaultedHeaders = {
        ...contentType
      };
      return response.customError({
        headers: defaultedHeaders,
        statusCode: err.statusCode,
        body: {
          message: err.message,
          attributes: {
            success: false
          }
        }
      });
    }
  });
};
exports.getAlertsGroupAggregations = getAlertsGroupAggregations;