"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RemoteClusterForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _lib = require("../../../../../../common/lib");
var _constants = require("../../../../../../common/constants");
var _app_context = require("../../../../app_context");
var _documentation = require("../../../../services/documentation");
var _components = require("./components");
var _validators = require("./validators");
var _components2 = require("../components");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultClusterValues = {
  name: '',
  seeds: [],
  skipUnavailable: true,
  nodeConnections: 3,
  proxyAddress: '',
  proxySocketConnections: 18,
  serverName: ''
};
const ERROR_TITLE_ID = 'removeClustersErrorTitle';
const ERROR_LIST_ID = 'removeClustersErrorList';
const RemoteClusterForm = ({
  confirmFormAction,
  onBack,
  isSaving,
  saveError,
  cluster,
  onConfigChange,
  confirmFormText,
  backFormText
}) => {
  const context = (0, _react.useContext)(_app_context.AppContext);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    isCloudEnabled
  } = context;
  const defaultMode = isCloudEnabled ? _constants.PROXY_MODE : _constants.SNIFF_MODE;
  const initialFieldsState = (0, _lodash.merge)({}, {
    ...defaultClusterValues,
    mode: defaultMode,
    cloudRemoteAddress: (cluster === null || cluster === void 0 ? void 0 : cluster.proxyAddress) || '',
    cloudAdvancedOptionsEnabled: (0, _validators.isCloudAdvancedOptionsEnabled)(cluster)
  }, cluster);
  const [fields, setFields] = (0, _react.useState)(initialFieldsState);
  const [fieldsErrors, setFieldsErrors] = (0, _react.useState)((0, _validators.validateCluster)(initialFieldsState, isCloudEnabled));
  const [areErrorsVisible, setAreErrorsVisible] = (0, _react.useState)(false);
  const [formHasBeenSubmited, setFormHasBeenSubmited] = (0, _react.useState)(false);
  const generateId = (0, _eui.htmlIdGenerator)();
  const getCluster = (0, _react.useCallback)(() => {
    const {
      name,
      mode,
      seeds,
      nodeConnections,
      proxyAddress,
      proxySocketConnections,
      serverName,
      skipUnavailable
    } = fields;
    const modeSettings = mode === _constants.PROXY_MODE ? {
      proxyAddress,
      proxySocketConnections,
      serverName
    } : {
      seeds,
      nodeConnections
    };
    return {
      name,
      skipUnavailable,
      mode,
      hasDeprecatedProxySetting: cluster === null || cluster === void 0 ? void 0 : cluster.hasDeprecatedProxySetting,
      ...modeSettings
    };
  }, [fields, cluster]);
  const handleNext = () => {
    if (hasErrors()) {
      setAreErrorsVisible(true);
      return;
    }
    setFormHasBeenSubmited(true);
    confirmFormAction(getCluster());
  };
  const onFieldsChange = (0, _react.useCallback)(changedFields => {
    // when cloud remote address changes, fill proxy address and server name
    const {
      cloudRemoteAddress,
      cloudAdvancedOptionsEnabled
    } = changedFields;
    if (cloudRemoteAddress) {
      const {
        proxyAddress,
        serverName
      } = (0, _validators.convertCloudRemoteAddressToProxyConnection)(cloudRemoteAddress);
      // Only change the server name if the advanced options are not currently open
      if (fields.cloudAdvancedOptionsEnabled) {
        changedFields = {
          ...changedFields,
          proxyAddress
        };
      } else {
        changedFields = {
          ...changedFields,
          proxyAddress,
          serverName
        };
      }
    }
    // If we switch off the advanced options, revert the server name to
    // the host name from the proxy address
    if (cloudAdvancedOptionsEnabled === false) {
      var _extractHostAndPort;
      const serverName = fields.proxyAddress ? (_extractHostAndPort = (0, _lib.extractHostAndPort)(fields.proxyAddress)) === null || _extractHostAndPort === void 0 ? void 0 : _extractHostAndPort.host : undefined;
      changedFields = {
        ...changedFields,
        serverName,
        proxySocketConnections: defaultClusterValues.proxySocketConnections
      };
    }
    const newFields = {
      ...fields,
      ...changedFields
    };
    setFields(newFields);
    setFieldsErrors((0, _validators.validateCluster)(newFields, isCloudEnabled));
  }, [fields, isCloudEnabled]);
  const hasErrors = (0, _react.useCallback)(() => {
    const errorValues = Object.values(fieldsErrors);
    return errorValues.some(error => error != null);
  }, [fieldsErrors]);
  (0, _react.useEffect)(() => {
    if (onConfigChange && formHasBeenSubmited) {
      const errors = hasErrors();
      setAreErrorsVisible(errors);
      onConfigChange(getCluster(), errors);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [fields]);
  const onSkipUnavailableChange = (0, _react.useCallback)(e => {
    const skipUnavailable = e.target.checked;
    onFieldsChange({
      skipUnavailable
    });
  }, [onFieldsChange]);
  const resetToDefault = (0, _react.useCallback)(fieldName => {
    onFieldsChange({
      [fieldName]: defaultClusterValues[fieldName]
    });
  }, [onFieldsChange]);
  const renderSkipUnavailable = () => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "s"
      }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.remoteClusters.remoteClusterForm.sectionSkipUnavailableTitle",
        defaultMessage: "Make remote cluster optional"
      }))),
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.remoteClusters.remoteClusterForm.sectionSkipUnavailableDescription",
        defaultMessage: "If any of the remote clusters are unavailable, the query request fails. To avoid this and continue to send requests to other clusters, enable Skip if unavailable. {learnMoreLink}",
        values: {
          learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: _documentation.skippingDisconnectedClustersUrl,
            target: "_blank"
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.remoteClusters.remoteClusterForm.sectionSkipUnavailableDescription.learnMoreLinkLabel",
            defaultMessage: "Learn more."
          }))
        }
      })),
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      "data-test-subj": "remoteClusterFormSkipUnavailableFormRow",
      css: (0, _react2.css)`
            padding-top: ${euiTheme.size.s};
          `,
      fullWidth: true,
      helpText: fields.skipUnavailable !== defaultClusterValues.skipUnavailable ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: () => {
          resetToDefault('skipUnavailable');
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.remoteClusters.remoteClusterForm.sectionSkipUnavailableResetLabel",
        defaultMessage: "Reset to default"
      })) : null
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: _i18n.i18n.translate('xpack.remoteClusters.remoteClusterForm.sectionSkipUnavailableLabel', {
        defaultMessage: 'Skip if unavailable'
      }),
      checked: !!fields.skipUnavailable,
      onChange: onSkipUnavailableChange,
      "data-test-subj": "remoteClusterFormSkipUnavailableFormToggle"
    })));
  };
  const renderErrors = () => {
    const {
      name: errorClusterName,
      seeds: errorsSeeds,
      proxyAddress: errorProxyAddress
    } = fieldsErrors;
    if (!areErrorsVisible || !hasErrors()) {
      return null;
    }
    const errorExplanations = [];
    if (errorClusterName) {
      errorExplanations.push({
        key: 'nameExplanation',
        field: _i18n.i18n.translate('xpack.remoteClusters.remoteClusterForm.inputNameErrorMessage', {
          defaultMessage: 'The "Name" field is invalid.'
        }),
        error: errorClusterName
      });
    }
    if (errorsSeeds) {
      errorExplanations.push({
        key: 'seedsExplanation',
        field: _i18n.i18n.translate('xpack.remoteClusters.remoteClusterForm.inputSeedsErrorMessage', {
          defaultMessage: 'The "Seed nodes" field is invalid.'
        }),
        error: errorsSeeds
      });
    }
    if (errorProxyAddress) {
      errorExplanations.push({
        key: 'proxyAddressExplanation',
        field: _i18n.i18n.translate('xpack.remoteClusters.remoteClusterForm.inputProxyErrorMessage', {
          defaultMessage: 'The "Proxy address" field is invalid.'
        }),
        error: errorProxyAddress
      });
    }
    const messagesToBeRendered = errorExplanations.length && /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("dl", {
      id: generateId(ERROR_LIST_ID),
      "aria-labelledby": generateId(ERROR_TITLE_ID)
    }, errorExplanations.map(({
      key,
      field,
      error
    }) => /*#__PURE__*/_react.default.createElement("div", {
      key: key
    }, /*#__PURE__*/_react.default.createElement("dt", null, field), /*#__PURE__*/_react.default.createElement("dd", null, error)))));
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: /*#__PURE__*/_react.default.createElement("span", {
        id: generateId(ERROR_TITLE_ID)
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.remoteClusters.remoteClusterForm.errorTitle",
        defaultMessage: "Some fields require your attention."
      })),
      color: "danger",
      iconType: "error"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiDelayRender, null, messagesToBeRendered), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      "data-test-subj": "remoteClusterFormGlobalError"
    }));
  };
  const isNew = !cluster;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, saveError && /*#__PURE__*/_react.default.createElement(_components2.SaveError, {
    saveError: saveError
  }), renderErrors(), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    "data-test-subj": "remoteClusterForm"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.sectionNameTitle",
      defaultMessage: "Remote cluster name"
    }))),
    description: isCloudEnabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.cloud.sectionNameDescription",
      defaultMessage: "A unique identifier for the remote cluster. Must match the {remoteClusterName} in this deployment\u2019s Cloud -> Security settings.",
      values: {
        remoteClusterName: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.remoteClusters.remoteClusterForm.cloud.sectionNameDescription.remoteClusterName",
          defaultMessage: "remote cluster name"
        }))
      }
    })) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.stateful.sectionNameDescription",
      defaultMessage: "A unique identifier for the remote cluster."
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "remoteClusterFormNameFormRow",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.fieldNameLabel",
      defaultMessage: "Remote cluster name"
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.fieldNameLabelHelpText",
      defaultMessage: "Must contain only letters, numbers, underscores, and dashes."
    }),
    error: fieldsErrors.name,
    isInvalid: Boolean(areErrorsVisible && fieldsErrors.name),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    isInvalid: Boolean(areErrorsVisible && fieldsErrors.name),
    value: fields.name,
    onChange: e => onFieldsChange({
      name: e.target.value
    }),
    fullWidth: true,
    disabled: !isNew,
    "data-test-subj": "remoteClusterFormNameInput"
  }))), /*#__PURE__*/_react.default.createElement(_components.ConnectionMode, {
    fields: fields,
    fieldsErrors: fieldsErrors,
    onFieldsChange: onFieldsChange,
    areErrorsVisible: areErrorsVisible
  }), renderSkipUnavailable()), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_components2.ActionButtons, {
    showRequest: true,
    disabled: areErrorsVisible && hasErrors(),
    isSaving: isSaving,
    handleNext: handleNext,
    onBack: onBack,
    confirmFormText: confirmFormText,
    backFormText: backFormText,
    cluster: getCluster(),
    nextButtonTestSubj: 'remoteClusterFormNextButton',
    backButtonTestSubj: 'remoteClusterFormBackButton',
    previousClusterMode: cluster === null || cluster === void 0 ? void 0 : cluster.mode
  }));
};
exports.RemoteClusterForm = RemoteClusterForm;