"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ANNUAL_SECONDS = void 0;
exports.useCalculateImpactEstimate = useCalculateImpactEstimate;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ANNUAL_SECONDS = exports.ANNUAL_SECONDS = 60 * 60 * 24 * 365;
function useCalculateImpactEstimate() {
  function calculateImpact({
    samples,
    totalSamples,
    totalSeconds
  }) {
    const annualizedScaleUp = ANNUAL_SECONDS / totalSeconds;
    const totalCoreSeconds = totalSamples / 19;
    const percentage = samples / totalSamples;
    const coreSeconds = totalCoreSeconds * percentage;
    const annualizedCoreSeconds = coreSeconds * annualizedScaleUp;
    return {
      percentage,
      coreSeconds,
      annualizedCoreSeconds
    };
  }
  return params => {
    return {
      totalSamples: calculateImpact({
        samples: params.totalSamples,
        totalSamples: params.totalSamples,
        totalSeconds: params.totalSeconds
      }),
      totalCPU: calculateImpact({
        samples: params.countInclusive,
        totalSamples: params.totalSamples,
        totalSeconds: params.totalSeconds
      }),
      selfCPU: calculateImpact({
        samples: params.countExclusive,
        totalSamples: params.totalSamples,
        totalSeconds: params.totalSeconds
      })
    };
  };
}