"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNeutralPalette = void 0;
var _i18n = require("@kbn/i18n");
var _categorical_palette = require("../../classes/categorical_palette");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const commonProps = {
  id: _constants.KbnPalette.Neutral,
  standalone: true,
  name: _i18n.i18n.translate('palettes.elastic.name', {
    defaultMessage: 'Neutral'
  })
};
const lightNeutralPalette = new _categorical_palette.KbnCategoricalPalette({
  ...commonProps,
  colors: ['#F6F9FC', '#D0D4DA', '#989FAA', '#666D78', '#373D45']
});
const darkNeutralPalette = new _categorical_palette.KbnCategoricalPalette({
  ...commonProps,
  colors: ['#F6F9FC', '#C9D4E6', '#89A0C4', '#546D95', '#283C5C']
});
const getNeutralPalette = darkMode => darkMode ? darkNeutralPalette : lightNeutralPalette;
exports.getNeutralPalette = getNeutralPalette;