"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDocumentByIdTool = void 0;
var _zod = require("@kbn/zod");
var _onechatCommon = require("@kbn/onechat-common");
var _onechatGenaiUtils = require("@kbn/onechat-genai-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDocumentByIdSchema = _zod.z.object({
  id: _zod.z.string().describe('ID of the document to retrieve'),
  index: _zod.z.string().describe('Name of the index to retrieve the document from')
});
const getDocumentByIdTool = () => {
  return {
    id: _onechatCommon.BuiltinToolIds.getDocumentById,
    description: 'Retrieve the full content (source) of a document based on its ID and index name.',
    schema: getDocumentByIdSchema,
    handler: async ({
      id,
      index
    }, {
      esClient
    }) => {
      return (0, _onechatGenaiUtils.getDocumentById)({
        id,
        index,
        esClient: esClient.asCurrentUser
      });
    },
    meta: {
      tags: [_onechatCommon.BuiltinTags.retrieval]
    }
  };
};
exports.getDocumentByIdTool = getDocumentByIdTool;