"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _sseUtilsClient = require("@kbn/sse-utils-client");
var _errors = require("../utils/errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AgentService {
  constructor({
    http
  }) {
    (0, _defineProperty2.default)(this, "http", void 0);
    this.http = http;
  }

  /**
   * Call an agent and await the final execution result.
   */
  async call({
    agentId,
    agentParams
  }) {
    return await this.http.get('/internal/onechat/agents/invoke');
  }

  /**
   * Call an agent and stream the events.
   */
  stream({
    agentId,
    agentParams
  }) {
    return (0, _rxjs.defer)(() => {
      return this.http.post('/internal/onechat/agents/stream', {
        asResponse: true,
        rawResponse: true,
        body: JSON.stringify({
          agentId,
          agentParams
        })
      });
    }).pipe(
    // @ts-expect-error SseEvent mixin issue
    (0, _sseUtilsClient.httpResponseIntoObservable)(), (0, _errors.unwrapOnechatErrors)());
  }
}
exports.AgentService = AgentService;