"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateEsql = void 0;
var _rxjs = require("rxjs");
var _inferenceCommon = require("@kbn/inference-common");
var _server = require("@kbn/inference-plugin/server");
var _index_explorer = require("./index_explorer");
var _get_mappings = require("./steps/get_mappings");
var _esql = require("./utils/esql");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const generateEsql = async ({
  query,
  context,
  index,
  model,
  esClient
}) => {
  let selectedIndex;
  let mappings;
  if (index) {
    selectedIndex = index;
    const indexMappings = await (0, _get_mappings.getIndexMappings)({
      indices: [index],
      esClient
    });
    mappings = indexMappings[index].mappings;
  } else {
    const {
      indices: [firstIndex]
    } = await (0, _index_explorer.indexExplorer)({
      query,
      esClient,
      limit: 1,
      model
    });
    selectedIndex = firstIndex.indexName;
    mappings = firstIndex.mappings;
  }
  const esqlEvents$ = (0, _server.naturalLanguageToEsql)({
    // @ts-expect-error using a scoped inference client
    connectorId: undefined,
    client: model.inferenceClient,
    logger: {
      debug: () => undefined
    },
    input: `
        Your task is to generate an ES|QL query.

        - User query: "${query}",
        - Additional context: "${context !== null && context !== void 0 ? context : 'N/A'}
        - Index to use: "${selectedIndex}"
        - Mapping of this index:
        \`\`\`json
        ${JSON.stringify(mappings, undefined, 2)}
        \`\`\`

        Given those info, please generate an ES|QL query to address the user request
        `
  });
  const messages = await (0, _rxjs.firstValueFrom)(esqlEvents$.pipe((0, _rxjs.filter)(_inferenceCommon.isChatCompletionEvent), (0, _rxjs.filter)(_inferenceCommon.isChatCompletionMessageEvent), (0, _rxjs.toArray)()));
  const fullContent = messages.map(message => message.content).join('\n');
  const esqlQueries = (0, _esql.extractEsqlQueries)(fullContent);
  return {
    answer: fullContent,
    queries: esqlQueries
  };
};
exports.generateEsql = generateEsql;