"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.filterProviderTools = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const matches = (rule, tool) => {
  if (rule.type === 'by_tool_id') {
    return tool.meta.providerId === rule.providerId && rule.toolIds.includes(tool.id);
  } else if (rule.type === 'by_provider_id') {
    return tool.meta.providerId === rule.providerId;
  } else {
    throw new Error('Unknown rule type');
  }
};
const anyMatch = (rules, tool) => {
  return rules.some(rule => matches(rule, tool));
};
const filterProviderTools = async ({
  provider,
  rules,
  request
}) => {
  const tools = await provider.list({
    request
  });
  return tools.filter(tool => anyMatch(rules, tool));
};
exports.filterProviderTools = filterProviderTools;