"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.otelHostOnboardingRouteRepository = void 0;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _create_observability_onboarding_server_route = require("../create_observability_onboarding_server_route");
var _get_fallback_urls = require("../../lib/get_fallback_urls");
var _get_agent_version = require("../../lib/get_agent_version");
var _create_shipper_api_key = require("../../lib/api_key/create_shipper_api_key");
var _has_log_monitoring_privileges = require("../../lib/api_key/has_log_monitoring_privileges");
var _create_managed_otlp_service_api_key = require("../../lib/api_key/create_managed_otlp_service_api_key");
var _get_managed_otlp_service_url = require("../../lib/get_managed_otlp_service_url");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const setupFlowRoute = (0, _create_observability_onboarding_server_route.createObservabilityOnboardingServerRoute)({
  endpoint: 'POST /internal/observability_onboarding/otel_host/setup',
  security: {
    authz: {
      enabled: false,
      reason: 'This route has custom authorization logic using Elasticsearch client'
    }
  },
  async handler(resources) {
    var _plugins$cloud, _plugins$cloud$setup, _plugins$cloud2, _plugins$cloud2$setup;
    const {
      context,
      config,
      plugins,
      kibanaVersion,
      services: {
        esLegacyConfigService
      }
    } = resources;
    const {
      elasticsearch: {
        client
      }
    } = await context.core;
    const hasPrivileges = await (0, _has_log_monitoring_privileges.hasLogMonitoringPrivileges)(client.asCurrentUser);
    if (!hasPrivileges) {
      throw _boom.default.forbidden('Insufficient permissions to create API key');
    }
    const fleetPluginStart = await plugins.fleet.start();
    const elasticAgentVersionInfo = await (0, _get_agent_version.getAgentVersionInfo)(fleetPluginStart, kibanaVersion);
    const elasticsearchUrlList = (_plugins$cloud = plugins.cloud) !== null && _plugins$cloud !== void 0 && (_plugins$cloud$setup = _plugins$cloud.setup) !== null && _plugins$cloud$setup !== void 0 && _plugins$cloud$setup.elasticsearchUrl ? [(_plugins$cloud2 = plugins.cloud) === null || _plugins$cloud2 === void 0 ? void 0 : (_plugins$cloud2$setup = _plugins$cloud2.setup) === null || _plugins$cloud2$setup === void 0 ? void 0 : _plugins$cloud2$setup.elasticsearchUrl] : await (0, _get_fallback_urls.getFallbackESUrl)(esLegacyConfigService);
    const {
      encoded: apiKeyEncoded
    } = config.serverless.enabled ? await (0, _create_managed_otlp_service_api_key.createManagedOtlpServiceApiKey)(client.asCurrentUser, `ingest-otel-host`) : await (0, _create_shipper_api_key.createShipperApiKey)(client.asCurrentUser, `otel-host`);
    return {
      elasticsearchUrl: elasticsearchUrlList.length > 0 ? elasticsearchUrlList[0] : '',
      elasticAgentVersionInfo,
      apiKeyEncoded,
      managedOtlpServiceUrl: await (0, _get_managed_otlp_service_url.getManagedOtlpServiceUrl)(resources)
    };
  }
});
const otelHostOnboardingRouteRepository = exports.otelHostOnboardingRouteRepository = {
  ...setupFlowRoute
};