"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AutoDetectPage = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _pricing_features = require("../../../common/pricing_features");
var _template = require("./template");
var _custom_header = require("../header/custom_header");
var _auto_detect = require("../quickstart_flows/auto_detect");
var _use_pricing_feature = require("../quickstart_flows/shared/use_pricing_feature");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AutoDetectPage = () => {
  const metricsOnboardingEnabled = (0, _use_pricing_feature.usePricingFeature)(_pricing_features.ObservabilityOnboardingPricingFeature.METRICS_ONBOARDING);
  return /*#__PURE__*/_react.default.createElement(_template.PageTemplate, {
    customHeader: /*#__PURE__*/_react.default.createElement(_custom_header.CustomHeader, {
      euiIconType: "consoleApp",
      headlineCopy: metricsOnboardingEnabled ? _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.customHeader.system.text', {
        defaultMessage: 'Auto-detect logs and metrics'
      }) : _i18n.i18n.translate('xpack.observability_onboarding.logsEssential.experimentalOnboardingFlow.customHeader.system.text', {
        defaultMessage: 'Auto-detect logs'
      }),
      captionCopy: metricsOnboardingEnabled ? _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.customHeader.system.description', {
        defaultMessage: 'This installation scans your host and auto-detects log and metric files.'
      }) : _i18n.i18n.translate('xpack.observability_onboarding.logsEssential.experimentalOnboardingFlow.customHeader.system.description', {
        defaultMessage: 'This installation scans your host and auto-detects log files.'
      })
    })
  }, /*#__PURE__*/_react.default.createElement(_auto_detect.AutoDetectPanel, null));
};
exports.AutoDetectPage = AutoDetectPage;