"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SourceDestination = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _source_tooltip = require("./source_tooltip");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SourceDestination = props => {
  const {
    sourceName,
    targetName,
    targetTransportAddress
  } = props;
  const targetTransportAddressContent = targetTransportAddress || _i18n.i18n.translate('xpack.monitoring.elasticsearch.shardActivity.unknownTargetAddressContent', {
    defaultMessage: 'Unknown'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_source_tooltip.SourceTooltip, props, sourceName)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "arrowRight",
    size: "s"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: targetTransportAddressContent,
    position: "bottom"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, null, targetName))));
};
exports.SourceDestination = SourceDestination;