"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "dataVizIndexOrSearchRouteFactory", {
  enumerable: true,
  get: function () {
    return _data_view_select.dataVizIndexOrSearchRouteFactory;
  }
});
exports.indexOrSearchRouteFactory = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _locator = require("../../../../locator");
var _router = require("../../router");
var _breadcrumbs = require("../../breadcrumbs");
var _index_or_search_page_wrapper = require("./index_or_search_page_wrapper");
var _data_view_select = require("../data_view_select");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getBreadcrumbs = navigateToApp => [(0, _breadcrumbs.getStackManagementBreadcrumb)(navigateToApp), (0, _breadcrumbs.getMlManagementBreadcrumb)('ANOMALY_DETECTION_MANAGEMENT_BREADCRUMB', navigateToApp), {
  text: _i18n.i18n.translate('xpack.ml.jobsBreadcrumbs.createJobLabel', {
    defaultMessage: 'Create job'
  })
}];
const indexOrSearchRouteFactory = mlManagementLocator => ({
  path: (0, _router.createPath)(_locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB_SELECT_INDEX),
  render: (props, deps) => /*#__PURE__*/_react.default.createElement(_index_or_search_page_wrapper.PageWrapper, (0, _extends2.default)({}, props, {
    nextStepPath: (0, _router.createPath)(_locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB_SELECT_TYPE),
    deps: deps,
    mode: _index_or_search_page_wrapper.MODE.NEW_JOB
  })),
  breadcrumbs: getBreadcrumbs(mlManagementLocator)
});
exports.indexOrSearchRouteFactory = indexOrSearchRouteFactory;