"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditConditionLink = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _format_value = require("../../../formatters/format_value");
var _utils = require("../utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * React component for quick edit of the numeric condition part of a rule,
 * containing a number field input for editing the condition value.
 */

class EditConditionLink extends _react.Component {
  constructor(props) {
    super(props);

    // Initialize value to anomaly value, if it exists.
    // Do rounding at this initialization stage. Then if the user
    // really wants to define to higher precision they can.
    // Format based on magnitude of value at this stage, rather than using the
    // Kibana field formatter (if set) which would add complexity converting
    // the entered value to / from e.g. bytes.
    (0, _defineProperty2.default)(this, "onChangeValue", event => {
      const enteredValue = event.target.value;
      this.setState({
        value: enteredValue !== '' ? +enteredValue : ''
      });
    });
    (0, _defineProperty2.default)(this, "onUpdateClick", () => {
      const {
        conditionIndex,
        updateConditionValue
      } = this.props;
      updateConditionValue(conditionIndex, this.state.value);
    });
    let value = '';
    const anomaly = this.props.anomaly;
    const anomalyValue = (0, _utils.getAppliesToValueFromAnomaly)(anomaly, props.appliesTo);
    if (anomalyValue !== undefined) {
      value = +(0, _format_value.formatValue)(anomalyValue, anomaly.source.function);
    }
    this.state = {
      value
    };
  }
  render() {
    const value = this.state.value;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: 's'
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.ruleEditor.editConditionLink.updateRuleConditionFromText",
      defaultMessage: "Update rule condition from {conditionValue} to",
      values: {
        conditionValue: this.props.conditionValue
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      placeholder: _i18n.i18n.translate('xpack.ml.ruleEditor.editConditionLink.enterValuePlaceholder', {
        defaultMessage: 'Enter value'
      }),
      compressed: true,
      value: value,
      onChange: this.onChangeValue,
      "aria-label": _i18n.i18n.translate('xpack.ml.ruleEditor.editConditionLink.enterNumericValueForConditionAriaLabel', {
        defaultMessage: 'Enter numeric value for condition'
      })
    })), value !== '' && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      size: "s",
      onClick: () => this.onUpdateClick()
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.ruleEditor.editConditionLink.updateLinkText",
      defaultMessage: "Update"
    }))));
  }
}
exports.EditConditionLink = EditConditionLink;
(0, _defineProperty2.default)(EditConditionLink, "propTypes", {
  conditionIndex: _propTypes.default.number.isRequired,
  conditionValue: _propTypes.default.number.isRequired,
  appliesTo: _propTypes.default.oneOf([_mlAnomalyUtils.ML_DETECTOR_RULE_APPLIES_TO.ACTUAL, _mlAnomalyUtils.ML_DETECTOR_RULE_APPLIES_TO.TYPICAL, _mlAnomalyUtils.ML_DETECTOR_RULE_APPLIES_TO.DIFF_FROM_TYPICAL]),
  anomaly: _propTypes.default.object.isRequired,
  updateConditionValue: _propTypes.default.func.isRequired
});