"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobSelectorBadge = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _group_color_utils = require("../../../../../common/util/group_color_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const JobSelectorBadge = ({
  icon,
  id,
  isGroup = false,
  numJobs,
  removeId
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const color = isGroup ? (0, _group_color_utils.tabColor)(id, euiTheme) : 'hollow';
  let props = {
    color
  };
  let jobCount;
  if (icon === true && removeId) {
    // @ts-ignore
    props = {
      ...props,
      iconType: 'cross',
      iconSide: 'right',
      onClick: () => removeId(id),
      onClickAriaLabel: 'Remove id'
    };
  }
  if (numJobs !== undefined) {
    jobCount = _i18n.i18n.translate('xpack.ml.jobSelector.selectedGroupJobs', {
      defaultMessage: `({jobsCount, plural, one {# job} other {# jobs}})`,
      values: {
        jobsCount: numJobs
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
    key: `${id}-id`,
    "data-test-subj": `mlJobSelectionBadge ${id}`
  }, props), `${id}${jobCount ? jobCount : ''}`);
};
exports.JobSelectorBadge = JobSelectorBadge;