"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createNotificationChannel = void 0;
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createNotificationChannel = () => {
  const eventsSubject = new _rxjs.ReplaySubject(1);
  const createService = () => eventsSubject.asObservable();
  const notify = eventExpr => (context, event) => {
    const eventToSend = eventExpr(context, event);
    if (eventToSend != null) {
      eventsSubject.next(eventToSend);
    }
  };
  return {
    createService,
    notify
  };
};
exports.createNotificationChannel = createNotificationChannel;