"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WrappingHelpPopover = exports.HelpPopoverButton = exports.HelpPopover = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _react2 = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HelpPopoverButton = ({
  children,
  onClick
}) => {
  const euiThemeContext = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: onClick
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "s",
    type: "question",
    css: helpPopoverStyles.button(euiThemeContext)
  }), children));
};
exports.HelpPopoverButton = HelpPopoverButton;
const HelpPopoverContent = ({
  title,
  children
}) => {
  const euiThemeContext = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, title && /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "m"
  }, title), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    className: "eui-yScroll",
    size: "s",
    css: helpPopoverStyles.content(euiThemeContext)
  }, children));
};
const helpPopoverStyles = {
  button: ({
    euiTheme
  }) => (0, _react2.css)`
    margin-right: ${euiTheme.size.xs};
  `,
  content: ({
    euiTheme
  }) => (0, _react2.css)`
    max-height: 40vh;
    padding: ${euiTheme.size.m};
  `
};
const HelpPopover = ({
  anchorPosition,
  button,
  children,
  closePopover,
  isOpen,
  title
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: anchorPosition,
    button: button,
    closePopover: closePopover,
    isOpen: isOpen,
    ownFocus: true,
    panelStyle: {
      maxInlineSize: '480px'
    },
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(HelpPopoverContent, {
    title: title
  }, children));
};
exports.HelpPopover = HelpPopover;
const WrappingHelpPopover = ({
  anchorPosition,
  button,
  children,
  closePopover,
  isOpen,
  title,
  startServices
}) => {
  return /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, startServices, /*#__PURE__*/_react.default.createElement(_eui.EuiWrappingPopover, {
    anchorPosition: anchorPosition,
    button: button,
    closePopover: closePopover,
    isOpen: isOpen,
    ownFocus: true,
    panelStyle: {
      maxInlineSize: '480px'
    },
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(HelpPopoverContent, {
    title: title
  }, children)));
};
exports.WrappingHelpPopover = WrappingHelpPopover;