"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePluginConfig = exports.PluginConfigProvider = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PluginConfigContext = /*#__PURE__*/(0, _react.createContext)(undefined);
const usePluginConfig = () => {
  const context = (0, _react.useContext)(PluginConfigContext);
  if (context === undefined) {
    throw new Error('PluginConfigContext value was not initialized. Use context provider to set the value before using it.');
  }
  return context;
};
exports.usePluginConfig = usePluginConfig;
const PluginConfigProvider = exports.PluginConfigProvider = PluginConfigContext.Provider;