"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLogsCharts = void 0;
var _i18n = require("@kbn/i18n");
var _react = require("react");
var _use_chart_series_color = require("./use_chart_series_color");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LOG_RATE = _i18n.i18n.translate('xpack.infra.assetDetails.charts.logRate', {
  defaultMessage: 'Log Rate'
});
const LOG_ERROR_RATE = _i18n.i18n.translate('xpack.infra.assetDetails.charts.logErrorRate', {
  defaultMessage: 'Log Error Rate'
});
const logRateMetric = {
  id: 'logMetric',
  chartType: 'metric',
  title: LOG_RATE,
  label: LOG_RATE,
  trendLine: true,
  value: 'count()',
  format: 'number',
  decimals: 1,
  normalizeByUnit: 's'
};
const logErrorRateMetric = {
  id: 'logErrorMetric',
  chartType: 'metric',
  title: LOG_ERROR_RATE,
  label: LOG_ERROR_RATE,
  trendLine: true,
  value: 'count(kql=\'log.level: "error" OR log.level: "ERROR" OR error.log.level: "error" OR error.log.level: "ERROR"\')',
  format: 'number',
  decimals: 1,
  normalizeByUnit: 's'
};
const useLogsCharts = ({
  dataViewId,
  seriesColor
}) => {
  seriesColor = (0, _use_chart_series_color.useChartSeriesColor)(seriesColor);
  return (0, _react.useMemo)(() => {
    const dataset = dataViewId && {
      dataset: {
        index: dataViewId
      }
    };
    return {
      charts: [{
        ...logRateMetric,
        ...dataset,
        seriesColor
      }, {
        ...logErrorRateMetric,
        ...dataset,
        seriesColor
      }]
    };
  }, [dataViewId, seriesColor]);
};
exports.useLogsCharts = useLogsCharts;