"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContextProviders = void 0;
var _react = _interopRequireDefault(require("react"));
var _use_reload_request_time = require("../../hooks/use_reload_request_time");
var _use_asset_details_render_props = require("./hooks/use_asset_details_render_props");
var _use_date_picker = require("./hooks/use_date_picker");
var _use_loading_state = require("./hooks/use_loading_state");
var _use_metadata_state = require("./hooks/use_metadata_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RenderWithOptionalSearchSessionProvider = ({
  renderMode,
  children
}) => {
  if (renderMode.mode === 'flyout') {
    // flyout mode requires its own search session so that it doesn't interfere with the main page
    return /*#__PURE__*/_react.default.createElement(_use_reload_request_time.ReloadRequestTimeProvider, null, children);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
};
const ContextProviders = ({
  children,
  ...props
}) => {
  const {
    assetId,
    assetName,
    autoRefresh,
    dateRange,
    overrides,
    assetType = 'host',
    renderMode
  } = props;
  return /*#__PURE__*/_react.default.createElement(RenderWithOptionalSearchSessionProvider, {
    renderMode: renderMode
  }, /*#__PURE__*/_react.default.createElement(_use_date_picker.DatePickerProvider, {
    dateRange: dateRange,
    autoRefresh: autoRefresh
  }, /*#__PURE__*/_react.default.createElement(_use_loading_state.LoadingStateProvider, null, /*#__PURE__*/_react.default.createElement(_use_metadata_state.MetadataStateProvider, {
    assetId: assetId,
    assetType: assetType
  }, /*#__PURE__*/_react.default.createElement(_use_asset_details_render_props.AssetDetailsRenderPropsProvider, {
    assetId: assetId,
    assetName: assetName,
    assetType: assetType,
    overrides: overrides,
    renderMode: renderMode
  }, children)))));
};
exports.ContextProviders = ContextProviders;