"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Callouts = void 0;
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/metrics-data-access-plugin/common");
var _use_asset_details_url_state = require("../hooks/use_asset_details_url_state");
var _use_asset_details_render_props = require("../hooks/use_asset_details_render_props");
var _legacy_metric_callout = require("./callouts/legacy_metric_callout");
var _types = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INCOMING_ALERT_CALLOUT_VISIBLE_FOR = [_types.ContentTabIds.OVERVIEW, _types.ContentTabIds.METRICS];
const isSnapshotMetricType = (inventoryModel, value) => {
  return !!value && !!inventoryModel.metrics.snapshot[value];
};
const Callouts = () => {
  var _assetConfig$legacyMe;
  const {
    asset
  } = (0, _use_asset_details_render_props.useAssetDetailsRenderPropsContext)();
  const [state] = (0, _use_asset_details_url_state.useAssetDetailsUrlState)();
  const assetConfig = (0, _common.findInventoryModel)(asset.type);
  const alertMetric = isSnapshotMetricType(assetConfig, state === null || state === void 0 ? void 0 : state.alertMetric) ? state === null || state === void 0 ? void 0 : state.alertMetric : undefined;
  if (asset.type === 'host' && alertMetric && (_assetConfig$legacyMe = assetConfig.legacyMetrics) !== null && _assetConfig$legacyMe !== void 0 && _assetConfig$legacyMe.includes(alertMetric)) {
    return /*#__PURE__*/_react.default.createElement(_legacy_metric_callout.LegacyAlertMetricCallout, {
      visibleFor: INCOMING_ALERT_CALLOUT_VISIBLE_FOR,
      metric: alertMetric
    });
  }
  return null;
};
exports.Callouts = Callouts;