"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditDataRetentionModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _validations = require("./validations");
var _schema = require("./schema");
var _shared_imports = require("../../../../../shared_imports");
var _documentation = require("../../../../services/documentation");
var _common = require("../../../../../../common");
var _time_units = require("../../../../constants/time_units");
var _data_streams = require("../../../../lib/data_streams");
var _app_context = require("../../../../app_context");
var _shared = require("../../../../components/shared");
var _api = require("../../../../services/api");
var _mixed_indices_callout = require("./mixed_indices_callout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EditDataRetentionModal = ({
  dataStreams,
  ilmPolicyName,
  ilmPolicyLink,
  onClose,
  isBulkEdit
}) => {
  var _dataStreams$;
  const lifecycle = (_dataStreams$ = dataStreams[0]) === null || _dataStreams$ === void 0 ? void 0 : _dataStreams$.lifecycle;
  const isSingleDataStream = dataStreams.length === 1;
  const {
    history,
    plugins: {
      cloud
    }
  } = (0, _app_context.useAppContext)();
  const dataStreamNames = dataStreams.map(({
    name
  }) => name);
  const globalMaxRetention = (0, _data_streams.deserializeGlobalMaxRetention)(lifecycle === null || lifecycle === void 0 ? void 0 : lifecycle.globalMaxRetention);
  const {
    size,
    unit
  } = isSingleDataStream ? (0, _common.splitSizeAndUnits)(lifecycle === null || lifecycle === void 0 ? void 0 : lifecycle.data_retention) : {
    size: undefined,
    unit: undefined
  };
  const {
    services: {
      notificationService
    },
    config: {
      enableTogglingDataRetention,
      enableProjectLevelRetentionChecks
    }
  } = (0, _app_context.useAppContext)();
  const {
    form
  } = (0, _shared_imports.useForm)({
    defaultValue: {
      dataRetention: size,
      timeUnit: unit || 'd',
      dataRetentionEnabled: isSingleDataStream ? lifecycle === null || lifecycle === void 0 ? void 0 : lifecycle.enabled : true,
      // When data retention is not set and lifecycle is enabled, is the only scenario in
      // which data retention will be infinite. If lifecycle isnt set or is not enabled, we
      // dont have inifinite data retention.
      infiniteRetentionPeriod: isSingleDataStream && (lifecycle === null || lifecycle === void 0 ? void 0 : lifecycle.enabled) && !(lifecycle !== null && lifecycle !== void 0 && lifecycle.data_retention)
    },
    schema: _schema.editDataRetentionFormSchema,
    id: 'editDataRetentionForm'
  });
  const [formData] = (0, _shared_imports.useFormData)({
    form
  });
  const isDirty = (0, _shared_imports.useFormIsModified)({
    form
  });
  const formHasErrors = form.getErrors().length > 0;
  const disableSubmit = formHasErrors || !isDirty || form.isValid === false;

  // Whenever a form data field changes, we need to re-validate
  // the dataRetention field
  (0, _react.useEffect)(() => {
    form.validateFields(['dataRetention']);
  }, [form, formData]);
  const onSubmitForm = async () => {
    const {
      isValid,
      data
    } = await form.submit();
    if (!isValid) {
      return;
    }

    // When enableTogglingDataRetention is disabled (ie: serverless) we don't mount
    // the dataRetentionEnabled field in the UI, which means that the form state for
    // this field regardless if it has defaultValue or if its set with form.setValue.
    // This seems to be a design decision from the formlib and there doesnt seem to
    // be a way around it AFAICT.
    // So when that happens we want to make sure that the dataRetention is always enabled.
    if (!(0, _lodash.has)(data, 'dataRetentionEnabled')) {
      data.dataRetentionEnabled = true;
    }
    return (0, _api.updateDataRetention)(dataStreamNames, data).then(({
      data: responseData,
      error
    }) => {
      if (responseData) {
        // If the response came back with a warning from ES, rely on that for the
        // toast message.
        if (responseData.warning) {
          notificationService.showWarningToast(responseData.warning);
          return onClose({
            hasUpdatedDataRetention: true
          });
        }
        const successMessage = isBulkEdit ? _i18n.i18n.translate('xpack.idxMgmt.dataStreams.editDataRetentionModal.successBulkDataRetentionNotification', {
          defaultMessage: 'Data retention has been updated for {dataStreamCount, plural, one {one data stream} other {{dataStreamCount} data streams}}.',
          values: {
            dataStreamCount: dataStreams.length
          }
        }) : _i18n.i18n.translate('xpack.idxMgmt.dataStreams.editDataRetentionModal.successDataRetentionNotification', {
          defaultMessage: 'Data retention {disabledDataRetention, plural, one { disabled } other { updated } }',
          values: {
            disabledDataRetention: !data.dataRetentionEnabled ? 1 : 0
          }
        });
        notificationService.showSuccessToast(successMessage);
        return onClose({
          hasUpdatedDataRetention: true
        });
      }
      if (error) {
        const errorMessage = isBulkEdit ? _i18n.i18n.translate('xpack.idxMgmt.dataStreams.editDataRetentionModal.errorBulkDataRetentionNotification', {
          defaultMessage: 'There was an error updating the retention period. Try again later.'
        }) : _i18n.i18n.translate('xpack.idxMgmt.dataStreams.editDataRetentionModal.errorDataRetentionNotification', {
          defaultMessage: "Error updating data retention: ''{error}''",
          values: {
            error: error.message
          }
        });
        notificationService.showDangerToast(errorMessage);
      }
      onClose();
    });
  };
  const affectedDataStreams = dataStreams.filter(ds => {
    var _ds$lifecycle, _ds$lifecycle2, _ds$lifecycle3, _ds$lifecycle4, _ds$lifecycle5;
    return formData.dataRetention && formData.timeUnit && (((_ds$lifecycle = ds.lifecycle) === null || _ds$lifecycle === void 0 ? void 0 : _ds$lifecycle.enabled) && !((_ds$lifecycle2 = ds.lifecycle) !== null && _ds$lifecycle2 !== void 0 && _ds$lifecycle2.data_retention) && !((_ds$lifecycle3 = ds.lifecycle) !== null && _ds$lifecycle3 !== void 0 && _ds$lifecycle3.effective_retention) || typeof ((_ds$lifecycle4 = ds.lifecycle) === null || _ds$lifecycle4 === void 0 ? void 0 : _ds$lifecycle4.data_retention) === 'string' && (0, _validations.isRetentionBiggerThan)(ds.lifecycle.data_retention, `${formData.dataRetention}${formData.timeUnit}`) || ((_ds$lifecycle5 = ds.lifecycle) === null || _ds$lifecycle5 === void 0 ? void 0 : _ds$lifecycle5.effective_retention) && (0, _validations.isRetentionBiggerThan)(ds.lifecycle.effective_retention, `${formData.dataRetention}${formData.timeUnit}`));
  }).map(({
    name
  }) => name);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: () => onClose(),
    "data-test-subj": "editDataRetentionModal",
    css: {
      width: 650
    },
    "aria-label": _i18n.i18n.translate('xpack.idxMgmt.dataStreams.editDataRetentionModal.modalAriaLabel', {
      defaultMessage: 'Edit data retention modal'
    })
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    form: form,
    "data-test-subj": "editDataRetentionForm"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, isBulkEdit ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.dataStreams.editDataRetentionModal.bulkEdit.modalTitleText",
    defaultMessage: "Edit data retention for {dataStreamCount} {dataStreamCount, plural, one {data stream} other {data streams}}",
    values: {
      dataStreamCount: dataStreams === null || dataStreams === void 0 ? void 0 : dataStreams.length
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.dataStreams.editDataRetentionModal.singleEdit.modalTitleText",
    defaultMessage: "Edit data retention"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, !isBulkEdit && (0, _data_streams.isDSLWithILMIndices)(dataStreams[0]) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_mixed_indices_callout.MixedIndicesCallout, {
    history: history,
    ilmPolicyLink: ilmPolicyLink,
    ilmPolicyName: ilmPolicyName,
    dataStreamName: dataStreamNames[0]
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), enableProjectLevelRetentionChecks && !isBulkEdit && (lifecycle === null || lifecycle === void 0 ? void 0 : lifecycle.globalMaxRetention) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.dataStreams.editDataRetentionModal.modalTitleText",
    defaultMessage: "Maximum data retention period is {maxRetention} {unitText}",
    values: {
      maxRetention: globalMaxRetention.size,
      unitText: globalMaxRetention.unitText
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), enableTogglingDataRetention && /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "dataRetentionEnabled",
    component: _shared_imports.ToggleField,
    "data-test-subj": "dataRetentionEnabledField"
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "dataRetention",
    component: _shared_imports.NumericField,
    validationData: {
      globalMaxRetention: lifecycle === null || lifecycle === void 0 ? void 0 : lifecycle.globalMaxRetention,
      enableProjectLevelRetentionChecks
    },
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: _documentation.documentationService.getUpdateExistingDS(),
      target: "_blank",
      external: true
    }, _i18n.i18n.translate('xpack.idxMgmt.dataStreams.editDataRetentionModal.learnMoreLinkText', {
      defaultMessage: 'How does this work?'
    }))),
    helpText: isBulkEdit && (lifecycle === null || lifecycle === void 0 ? void 0 : lifecycle.globalMaxRetention) && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.dataStreams.editDataRetentionModal.learnMoreLinkText",
      defaultMessage: "Maximum data retention period for this project is {maxRetention} {unitText}. {manageSettingsLink}",
      values: {
        maxRetention: globalMaxRetention.size,
        unitText: globalMaxRetention.unitText,
        manageSettingsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: cloud === null || cloud === void 0 ? void 0 : cloud.deploymentUrl,
          target: "_blank"
        }, _i18n.i18n.translate('xpack.idxMgmt.dataStreams.editDataRetentionModal.manageProjectSettingsLinkText', {
          defaultMessage: 'Manage project settings.'
        }))
      }
    }),
    componentProps: {
      fullWidth: true,
      euiFieldProps: {
        disabled: formData.infiniteRetentionPeriod || !formData.dataRetentionEnabled && enableTogglingDataRetention,
        'data-test-subj': `dataRetentionValue`,
        min: 1,
        append: /*#__PURE__*/_react.default.createElement(_shared.UnitField, {
          path: "timeUnit",
          options: _time_units.timeUnits,
          disabled: formData.infiniteRetentionPeriod || !formData.dataRetentionEnabled && enableTogglingDataRetention,
          euiFieldProps: {
            'data-test-subj': 'timeUnit',
            'aria-label': _i18n.i18n.translate('xpack.idxMgmt.dataStreams.editDataRetentionModal.unitsAriaLabel', {
              defaultMessage: 'Time unit'
            })
          }
        })
      }
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "infiniteRetentionPeriod",
    component: _shared_imports.ToggleField,
    "data-test-subj": "infiniteRetentionPeriod",
    label: _i18n.i18n.translate('xpack.idxMgmt.dataStreams.editDataRetentionModal.infiniteRetentionPeriodField', {
      defaultMessage: 'Keep data {withProjectLevelRetention, plural, one {up to maximum retention period} other {indefinitely}}',
      values: {
        withProjectLevelRetention: enableProjectLevelRetentionChecks ? 1 : 0
      }
    }),
    componentProps: {
      euiFieldProps: {
        disabled: !formData.dataRetentionEnabled && enableTogglingDataRetention
      }
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), affectedDataStreams.length > 0 && !formData.infiniteRetentionPeriod && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.idxMgmt.dataStreams.editDataRetentionModal.affectedDataStreamsCalloutTitle', {
      defaultMessage: 'Some data will be deleted'
    }),
    color: "danger",
    iconType: "warning",
    "data-test-subj": "reducedDataRetentionCallout"
  }, /*#__PURE__*/_react.default.createElement("p", null, isBulkEdit ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.dataStreams.editDataRetentionModal.bulkEdit.affectedDataStreamsCalloutText",
    defaultMessage: "The retention period will be reduced for {affectedDataStreamCount} {affectedDataStreamCount, plural, one {data stream} other {data streams}}. Data older than then new retention period will be permanently deleted.",
    values: {
      affectedDataStreamCount: affectedDataStreams.length
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.dataStreams.editDataRetentionModal.singleEdit.affectedDataStreamsSingleCalloutText",
    defaultMessage: "The retention period will be reduced. Data older than then new retention period will be permanently deleted."
  })), isBulkEdit && affectedDataStreams.length <= 10 && /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.dataStreams.editDataRetentionModal.affectedDataStreamsCalloutList",
    defaultMessage: "Affected data streams: {affectedDataStreams}",
    values: {
      affectedDataStreams: /*#__PURE__*/_react.default.createElement("b", null, affectedDataStreams.join(', '))
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "cancelButton",
    onClick: () => onClose(),
    "aria-label": _i18n.i18n.translate('xpack.idxMgmt.dataStreams.editDataRetentionModal.cancelButtonAriaLabel', {
      defaultMessage: 'Cancel editing data retention'
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.dataStreams.editDataRetentionModal.cancelButtonLabel",
    defaultMessage: "Cancel"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    type: "submit",
    isLoading: false,
    disabled: disableSubmit,
    "data-test-subj": "saveButton",
    onClick: onSubmitForm
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.dataStreams.editDataRetentionModal.saveButtonLabel",
    defaultMessage: "Save"
  })))));
};
exports.EditDataRetentionModal = EditDataRetentionModal;