"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GetUninstallTokensMetadataResponseSchema = exports.GetUninstallTokensMetadataRequestSchema = exports.GetUninstallTokenResponseSchema = exports.GetUninstallTokenRequestSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _utils = require("../../routes/schema/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GetUninstallTokensMetadataRequestSchema = exports.GetUninstallTokensMetadataRequestSchema = {
  query: _configSchema.schema.object({
    policyId: _configSchema.schema.maybe(_configSchema.schema.string({
      maxLength: 50,
      meta: {
        description: 'Partial match filtering for policy IDs'
      }
    })),
    search: _configSchema.schema.maybe(_configSchema.schema.string({
      maxLength: 50
    })),
    perPage: _configSchema.schema.maybe(_configSchema.schema.number({
      defaultValue: 20,
      min: 5,
      meta: {
        description: 'The number of items to return'
      }
    })),
    page: _configSchema.schema.maybe(_configSchema.schema.number({
      defaultValue: 1,
      min: 1
    }))
  })
};
const UninstallTokenMetadataSchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  policy_id: _configSchema.schema.string(),
  policy_name: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(null), _configSchema.schema.string()])),
  created_at: _configSchema.schema.string(),
  namespaces: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
});
const GetUninstallTokensMetadataResponseSchema = exports.GetUninstallTokensMetadataResponseSchema = (0, _utils.ListResponseSchema)(UninstallTokenMetadataSchema);
const GetUninstallTokenRequestSchema = exports.GetUninstallTokenRequestSchema = {
  params: _configSchema.schema.object({
    uninstallTokenId: _configSchema.schema.string()
  })
};
const GetUninstallTokenResponseSchema = exports.GetUninstallTokenResponseSchema = _configSchema.schema.object({
  item: UninstallTokenMetadataSchema.extends({
    token: _configSchema.schema.string()
  })
});