"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateDeprecatedComponentTemplates = updateDeprecatedComponentTemplates;
var _pMap = _interopRequireDefault(require("p-map"));
var _ = require("..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function updateDeprecatedComponentTemplates(esClient) {
  const componentTemplates = await esClient.cluster.getComponentTemplate({
    name: 'metrics-*'
  });
  const deprecatedTemplates = componentTemplates.component_templates.filter(componentTemplate => {
    var _componentTemplate$co, _componentTemplate$co2, _componentTemplate$co3;
    return ((_componentTemplate$co = componentTemplate.component_template._meta) === null || _componentTemplate$co === void 0 ? void 0 : _componentTemplate$co.managed_by) === 'fleet' && !!((_componentTemplate$co2 = componentTemplate.component_template.template.mappings) !== null && _componentTemplate$co2 !== void 0 && (_componentTemplate$co3 = _componentTemplate$co2._source) !== null && _componentTemplate$co3 !== void 0 && _componentTemplate$co3.mode);
  });
  _.appContextService.getLogger().debug(`Updating component templates with deprecated _source.mode config: ${deprecatedTemplates.map(template => template.name)}`);
  await (0, _pMap.default)(deprecatedTemplates, async componentTemplate => {
    var _settings$index, _settings$index2, _settings$index2$mapp;
    const source = componentTemplate.component_template.template.mappings._source;
    const {
      mode,
      ...restOfSource
    } = source;
    // export type IndicesSourceMode = 'disabled' | 'stored' | 'synthetic';
    // export type MappingSourceFieldMode = 'disabled' | 'stored' | 'synthetic';
    const settings = componentTemplate.component_template.template.settings;
    await esClient.cluster.putComponentTemplate({
      name: componentTemplate.name,
      template: {
        settings: {
          ...settings,
          index: {
            ...(settings === null || settings === void 0 ? void 0 : settings.index),
            mapping: {
              ...(settings === null || settings === void 0 ? void 0 : (_settings$index = settings.index) === null || _settings$index === void 0 ? void 0 : _settings$index.mapping),
              source: {
                ...(settings === null || settings === void 0 ? void 0 : (_settings$index2 = settings.index) === null || _settings$index2 === void 0 ? void 0 : (_settings$index2$mapp = _settings$index2.mapping) === null || _settings$index2$mapp === void 0 ? void 0 : _settings$index2$mapp.source),
                mode: mode
              }
            }
          }
        },
        mappings: {
          ...componentTemplate.component_template.template.mappings,
          _source: restOfSource
        }
      }
    });
  }, {
    concurrency: 10
  });
}