"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSavedObjectTypes = exports.OUTPUT_INCLUDE_AAD_FIELDS = exports.OUTPUT_ENCRYPTED_FIELDS = exports.FLEET_SERVER_HOST_ENCRYPTED_FIELDS = void 0;
exports.registerEncryptedSavedObjects = registerEncryptedSavedObjects;
exports.registerSavedObjects = registerSavedObjects;
var _constants = require("../../common/constants");
var _constants2 = require("../constants");
var _to_v8_12_ = require("./migrations/synthetics/to_v8_12_0");
var _to_v8_11_ = require("./migrations/security_solution/to_v8_11_0");
var _cloud_security_posture = require("./migrations/cloud_security_posture");
var _to_v8_10_ = require("./migrations/to_v8_10_0");
var _to_v8_10_2 = require("./migrations/synthetics/to_v8_10_0");
var _to_v8_10_3 = require("./migrations/security_solution/to_v8_10_0");
var _to_v7_10_ = require("./migrations/to_v7_10_0");
var _to_v7_11_ = require("./migrations/to_v7_11_0");
var _to_v7_12_ = require("./migrations/to_v7_12_0");
var _to_v7_13_ = require("./migrations/to_v7_13_0");
var _to_v7_14_ = require("./migrations/to_v7_14_0");
var _to_v7_15_ = require("./migrations/to_v7_15_0");
var _to_v7_16_ = require("./migrations/to_v7_16_0");
var _to_v8_0_ = require("./migrations/to_v8_0_0");
var _to_v8_2_ = require("./migrations/to_v8_2_0");
var _to_v8_3_ = require("./migrations/to_v8_3_0");
var _to_v8_4_ = require("./migrations/to_v8_4_0");
var _to_v8_5_ = require("./migrations/to_v8_5_0");
var _to_v8_6_ = require("./migrations/to_v8_6_0");
var _security_solution = require("./migrations/security_solution");
var _to_v8_8_ = require("./migrations/to_v8_8_0");
var _to_v8_9_ = require("./migrations/to_v8_9_0");
var _to_v8_11_0_ = require("./migrations/security_solution/to_v8_11_0_2");
var _settings_v = require("./model_versions/settings_v1");
var _security_solution2 = require("./model_versions/security_solution");
var _to_v8_15_ = require("./migrations/to_v8_15_0");
var _agent_policy_v = require("./model_versions/agent_policy_v4");
var _outputs = require("./model_versions/outputs");
var _v17_advanced_package_policy_fields = require("./model_versions/security_solution/v17_advanced_package_policy_fields");
var _package_policy_latest_revision_backfill = require("./model_versions/package_policy_latest_revision_backfill");
var _synthetics_disable_browser_input = require("./model_versions/synthetics_disable_browser_input");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * Saved object types and mappings
 *
 * Please update typings in `/common/types` as well as
 * schemas in `/server/types` if mappings are updated.
 */
const getSavedObjectTypes = (options = {
  useSpaceAwareness: false
}) => {
  const {
    useSpaceAwareness
  } = options;
  return {
    [_constants2.FLEET_SETUP_LOCK_TYPE]: {
      name: _constants2.FLEET_SETUP_LOCK_TYPE,
      indexPattern: _constants2.INGEST_SAVED_OBJECT_INDEX,
      hidden: false,
      namespaceType: 'agnostic',
      management: {
        importableAndExportable: false
      },
      mappings: {
        properties: {
          status: {
            type: 'keyword'
          },
          uuid: {
            type: 'text'
          },
          started_at: {
            type: 'date'
          }
        }
      }
    },
    [_constants2.SPACE_SETTINGS_SAVED_OBJECT_TYPE]: {
      name: _constants2.SPACE_SETTINGS_SAVED_OBJECT_TYPE,
      indexPattern: _constants2.INGEST_SAVED_OBJECT_INDEX,
      hidden: false,
      namespaceType: 'single',
      management: {
        importableAndExportable: false
      },
      mappings: {
        dynamic: false,
        properties: {}
      }
    },
    // Deprecated
    [_constants2.GLOBAL_SETTINGS_SAVED_OBJECT_TYPE]: {
      name: _constants2.GLOBAL_SETTINGS_SAVED_OBJECT_TYPE,
      indexPattern: _constants2.INGEST_SAVED_OBJECT_INDEX,
      hidden: false,
      namespaceType: 'agnostic',
      management: {
        importableAndExportable: false
      },
      mappings: {
        properties: {
          fleet_server_hosts: {
            type: 'keyword'
          },
          has_seen_add_data_notice: {
            type: 'boolean',
            index: false
          },
          prerelease_integrations_enabled: {
            type: 'boolean'
          },
          secret_storage_requirements_met: {
            type: 'boolean'
          },
          output_secret_storage_requirements_met: {
            type: 'boolean'
          },
          use_space_awareness_migration_status: {
            type: 'keyword',
            index: false
          },
          use_space_awareness_migration_started_at: {
            type: 'date',
            index: false
          },
          delete_unenrolled_agents: {
            properties: {
              enabled: {
                type: 'boolean',
                index: false
              },
              is_preconfigured: {
                type: 'boolean',
                index: false
              }
            }
          }
        }
      },
      migrations: {
        '7.10.0': _to_v7_10_.migrateSettingsToV7100,
        '7.13.0': _to_v7_13_.migrateSettingsToV7130,
        '8.6.0': _to_v8_6_.migrateSettingsToV860
      },
      modelVersions: {
        1: _settings_v.settingsV1,
        2: {
          changes: [{
            type: 'mappings_addition',
            addedMappings: {
              use_space_awareness_migration_status: {
                type: 'keyword',
                index: false
              },
              use_space_awareness_migration_started_at: {
                type: 'date',
                index: false
              }
            }
          }]
        },
        3: {
          changes: [{
            type: 'mappings_addition',
            addedMappings: {
              delete_unenrolled_agents: {
                properties: {
                  enabled: {
                    type: 'boolean',
                    index: false
                  },
                  is_preconfigured: {
                    type: 'boolean',
                    index: false
                  }
                }
              }
            }
          }]
        }
      }
    },
    [_constants2.LEGACY_AGENT_POLICY_SAVED_OBJECT_TYPE]: {
      name: _constants2.LEGACY_AGENT_POLICY_SAVED_OBJECT_TYPE,
      indexPattern: _constants2.INGEST_SAVED_OBJECT_INDEX,
      hidden: false,
      namespaceType: 'agnostic',
      management: {
        importableAndExportable: false
      },
      mappings: {
        dynamic: false,
        properties: {
          name: {
            type: 'keyword'
          },
          schema_version: {
            type: 'version'
          },
          description: {
            type: 'text'
          },
          namespace: {
            type: 'keyword'
          },
          is_managed: {
            type: 'boolean'
          },
          is_default: {
            type: 'boolean'
          },
          is_default_fleet_server: {
            type: 'boolean'
          },
          status: {
            type: 'keyword'
          },
          unenroll_timeout: {
            type: 'integer'
          },
          inactivity_timeout: {
            type: 'integer'
          },
          updated_at: {
            type: 'date'
          },
          updated_by: {
            type: 'keyword'
          },
          revision: {
            type: 'integer'
          },
          monitoring_enabled: {
            type: 'keyword',
            index: false
          },
          is_preconfigured: {
            type: 'keyword'
          },
          data_output_id: {
            type: 'keyword'
          },
          monitoring_output_id: {
            type: 'keyword'
          },
          download_source_id: {
            type: 'keyword'
          },
          fleet_server_host_id: {
            type: 'keyword'
          },
          agent_features: {
            properties: {
              name: {
                type: 'keyword'
              },
              enabled: {
                type: 'boolean'
              }
            }
          },
          is_protected: {
            type: 'boolean'
          },
          overrides: {
            type: 'flattened',
            index: false
          },
          keep_monitoring_alive: {
            type: 'boolean'
          },
          advanced_settings: {
            type: 'flattened',
            index: false
          },
          supports_agentless: {
            type: 'boolean'
          },
          global_data_tags: {
            type: 'flattened',
            index: false
          },
          agentless: {
            dynamic: false,
            properties: {}
          },
          monitoring_pprof_enabled: {
            type: 'boolean',
            index: false
          },
          monitoring_http: {
            type: 'flattened',
            index: false
          },
          monitoring_diagnostics: {
            type: 'flattened',
            index: false
          },
          required_versions: {
            type: 'flattened',
            index: false
          }
        }
      },
      migrations: {
        '7.10.0': _to_v7_10_.migrateAgentPolicyToV7100,
        '7.12.0': _to_v7_12_.migrateAgentPolicyToV7120,
        '8.4.0': _to_v8_4_.migrateAgentPolicyToV840,
        '8.5.0': _to_v8_5_.migrateAgentPolicyToV850,
        '8.9.0': _to_v8_9_.migrateAgentPolicyToV890
      },
      modelVersions: {
        '1': {
          changes: [{
            type: 'mappings_addition',
            addedMappings: {
              advanced_settings: {
                type: 'flattened',
                index: false
              }
            }
          }]
        },
        '2': {
          changes: [{
            type: 'mappings_addition',
            addedMappings: {
              supports_agentless: {
                type: 'boolean'
              }
            }
          }]
        },
        '3': {
          changes: [{
            type: 'mappings_addition',
            addedMappings: {
              global_data_tags: {
                type: 'flattened',
                index: false
              }
            }
          }]
        },
        '4': {
          changes: [{
            type: 'mappings_addition',
            addedMappings: {
              monitoring_pprof_enabled: {
                type: 'boolean',
                index: false
              },
              monitoring_http: {
                type: 'flattened',
                index: false
              },
              monitoring_diagnostics: {
                type: 'flattened',
                index: false
              }
            }
          }, {
            type: 'data_backfill',
            backfillFn: _agent_policy_v.backfillAgentPolicyToV4
          }]
        },
        '5': {
          changes: [{
            type: 'mappings_addition',
            addedMappings: {}
          }]
        },
        '6': {
          changes: [{
            type: 'mappings_addition',
            addedMappings: {
              agentless: {
                dynamic: false,
                properties: {}
              }
            }
          }]
        },
        '7': {
          changes: [{
            type: 'mappings_addition',
            addedMappings: {
              required_versions: {
                type: 'flattened',
                index: false
              }
            }
          }]
        }
      }
    },
    [_constants2.AGENT_POLICY_SAVED_OBJECT_TYPE]: {
      name: _constants2.AGENT_POLICY_SAVED_OBJECT_TYPE,
      indexPattern: _constants2.INGEST_SAVED_OBJECT_INDEX,
      hidden: false,
      namespaceType: 'multiple',
      management: {
        importableAndExportable: false
      },
      mappings: {
        dynamic: false,
        properties: {
          name: {
            type: 'keyword'
          },
          schema_version: {
            type: 'version'
          },
          description: {
            type: 'text'
          },
          namespace: {
            type: 'keyword'
          },
          is_managed: {
            type: 'boolean'
          },
          is_default: {
            type: 'boolean'
          },
          is_default_fleet_server: {
            type: 'boolean'
          },
          status: {
            type: 'keyword'
          },
          unenroll_timeout: {
            type: 'integer'
          },
          inactivity_timeout: {
            type: 'integer'
          },
          updated_at: {
            type: 'date'
          },
          updated_by: {
            type: 'keyword'
          },
          revision: {
            type: 'integer'
          },
          monitoring_enabled: {
            type: 'keyword',
            index: false
          },
          is_preconfigured: {
            type: 'keyword'
          },
          data_output_id: {
            type: 'keyword'
          },
          monitoring_output_id: {
            type: 'keyword'
          },
          download_source_id: {
            type: 'keyword'
          },
          fleet_server_host_id: {
            type: 'keyword'
          },
          agent_features: {
            properties: {
              name: {
                type: 'keyword'
              },
              enabled: {
                type: 'boolean'
              }
            }
          },
          is_protected: {
            type: 'boolean'
          },
          overrides: {
            type: 'flattened',
            index: false
          },
          keep_monitoring_alive: {
            type: 'boolean'
          },
          advanced_settings: {
            type: 'flattened',
            index: false
          },
          supports_agentless: {
            type: 'boolean'
          },
          global_data_tags: {
            type: 'flattened',
            index: false
          },
          agentless: {
            dynamic: false,
            properties: {}
          },
          required_versions: {
            type: 'flattened',
            index: false
          }
        }
      },
      modelVersions: {
        '1': {
          changes: [{
            type: 'mappings_addition',
            addedMappings: {}
          }]
        },
        '2': {
          changes: [{
            type: 'mappings_addition',
            addedMappings: {
              required_versions: {
                type: 'flattened',
                index: false
              }
            }
          }]
        }
      }
    },
    [_constants2.OUTPUT_SAVED_OBJECT_TYPE]: {
      name: _constants2.OUTPUT_SAVED_OBJECT_TYPE,
      indexPattern: _constants2.INGEST_SAVED_OBJECT_INDEX,
      hidden: false,
      namespaceType: 'agnostic',
      management: {
        importableAndExportable: false
      },
      mappings: {
        dynamic: false,
        properties: {
          output_id: {
            type: 'keyword',
            index: false
          },
          name: {
            type: 'keyword'
          },
          type: {
            type: 'keyword'
          },
          is_default: {
            type: 'boolean'
          },
          is_default_monitoring: {
            type: 'boolean'
          },
          hosts: {
            type: 'keyword'
          },
          ca_sha256: {
            type: 'keyword',
            index: false
          },
          ca_trusted_fingerprint: {
            type: 'keyword',
            index: false
          },
          service_token: {
            type: 'keyword',
            index: false
          },
          config: {
            type: 'flattened'
          },
          config_yaml: {
            type: 'text'
          },
          is_preconfigured: {
            type: 'boolean',
            index: false
          },
          is_internal: {
            type: 'boolean',
            index: false
          },
          ssl: {
            type: 'binary'
          },
          proxy_id: {
            type: 'keyword'
          },
          shipper: {
            dynamic: false,
            // we aren't querying or aggregating over this data, so we don't need to specify any fields
            properties: {}
          },
          allow_edit: {
            enabled: false
          },
          version: {
            type: 'keyword'
          },
          key: {
            type: 'keyword'
          },
          compression: {
            type: 'keyword'
          },
          compression_level: {
            type: 'integer'
          },
          client_id: {
            type: 'keyword'
          },
          auth_type: {
            type: 'keyword'
          },
          connection_type: {
            type: 'keyword'
          },
          username: {
            type: 'keyword'
          },
          password: {
            type: 'text',
            index: false
          },
          sasl: {
            dynamic: false,
            properties: {
              mechanism: {
                type: 'text'
              }
            }
          },
          partition: {
            type: 'keyword'
          },
          random: {
            dynamic: false,
            properties: {
              group_events: {
                type: 'integer'
              }
            }
          },
          round_robin: {
            dynamic: false,
            properties: {
              group_events: {
                type: 'integer'
              }
            }
          },
          hash: {
            dynamic: false,
            properties: {
              hash: {
                type: 'text'
              },
              random: {
                type: 'boolean'
              }
            }
          },
          topic: {
            type: 'text',
            index: false
          },
          topics: {
            dynamic: false,
            properties: {
              topic: {
                type: 'keyword'
              },
              when: {
                dynamic: false,
                properties: {
                  type: {
                    type: 'text'
                  },
                  condition: {
                    type: 'text'
                  }
                }
              }
            }
          },
          headers: {
            dynamic: false,
            properties: {
              key: {
                type: 'text'
              },
              value: {
                type: 'text'
              }
            }
          },
          timeout: {
            type: 'integer'
          },
          broker_timeout: {
            type: 'integer'
          },
          broker_ack_reliability: {
            type: 'text'
          },
          broker_buffer_size: {
            type: 'integer'
          },
          required_acks: {
            type: 'integer'
          },
          channel_buffer_size: {
            type: 'integer'
          },
          secrets: {
            dynamic: false,
            properties: {
              password: {
                dynamic: false,
                properties: {
                  id: {
                    type: 'keyword'
                  }
                }
              },
              ssl: {
                dynamic: false,
                properties: {
                  key: {
                    dynamic: false,
                    properties: {
                      id: {
                        type: 'keyword'
                      }
                    }
                  }
                }
              },
              service_token: {
                dynamic: false,
                properties: {
                  id: {
                    type: 'keyword'
                  }
                }
              }
            }
          },
          preset: {
            type: 'keyword',
            index: false
          }
        }
      },
      modelVersions: {
        '1': {
          changes: [{
            type: 'mappings_deprecation',
            deprecatedMappings: ['broker_ack_reliability', 'broker_buffer_size', 'channel_buffer_size']
          }, {
            type: 'data_backfill',
            backfillFn: _to_v8_10_.migrateOutputToV8100
          }],
          schemas: {
            forwardCompatibility: _to_v8_10_.migrateOutputEvictionsFromV8100
          }
        },
        '2': {
          changes: [{
            type: 'mappings_addition',
            addedMappings: {
              service_token: {
                type: 'keyword',
                index: false
              }
            }
          }]
        },
        '3': {
          changes: [{
            type: 'mappings_addition',
            addedMappings: {
              secrets: {
                properties: {
                  service_token: {
                    dynamic: false,
                    properties: {
                      id: {
                        type: 'keyword'
                      }
                    }
                  }
                }
              }
            }
          }]
        },
        '4': {
          changes: [{
            type: 'mappings_addition',
            addedMappings: {
              preset: {
                type: 'keyword',
                index: false
              }
            }
          }]
        },
        '5': {
          changes: [{
            type: 'mappings_addition',
            addedMappings: {
              is_internal: {
                type: 'boolean',
                index: false
              }
            }
          }]
        },
        '6': {
          changes: [{
            type: 'mappings_addition',
            addedMappings: {
              topic: {
                type: 'text',
                index: false
              }
            }
          }]
        },
        '7': {
          changes: [{
            type: 'mappings_deprecation',
            deprecatedMappings: ['topics']
          }, {
            type: 'data_backfill',
            backfillFn: _outputs.backfillOutputPolicyToV7
          }]
        },
        '8': {
          changes: [{
            type: 'mappings_addition',
            addedMappings: {}
          }]
        }
      },
      migrations: {
        '7.13.0': _to_v7_13_.migrateOutputToV7130,
        '8.0.0': _to_v8_0_.migrateOutputToV800
      }
    },
    [_constants.LEGACY_PACKAGE_POLICY_SAVED_OBJECT_TYPE]: {
      name: _constants.LEGACY_PACKAGE_POLICY_SAVED_OBJECT_TYPE,
      indexPattern: _constants2.INGEST_SAVED_OBJECT_INDEX,
      hidden: false,
      namespaceType: 'agnostic',
      management: {
        importableAndExportable: false
      },
      mappings: {
        dynamic: false,
        properties: {
          name: {
            type: 'keyword'
          },
          description: {
            type: 'text'
          },
          namespace: {
            type: 'keyword'
          },
          enabled: {
            type: 'boolean'
          },
          is_managed: {
            type: 'boolean'
          },
          policy_id: {
            type: 'keyword'
          },
          policy_ids: {
            type: 'keyword'
          },
          output_id: {
            type: 'keyword'
          },
          package: {
            properties: {
              name: {
                type: 'keyword'
              },
              title: {
                type: 'keyword'
              },
              version: {
                type: 'keyword'
              },
              requires_root: {
                type: 'boolean'
              }
            }
          },
          elasticsearch: {
            dynamic: false,
            properties: {}
          },
          vars: {
            type: 'flattened'
          },
          inputs: {
            dynamic: false,
            properties: {}
          },
          secret_references: {
            properties: {
              id: {
                type: 'keyword'
              }
            }
          },
          overrides: {
            type: 'flattened',
            index: false
          },
          supports_agentless: {
            type: 'boolean'
          },
          revision: {
            type: 'integer'
          },
          updated_at: {
            type: 'date'
          },
          updated_by: {
            type: 'keyword'
          },
          created_at: {
            type: 'date'
          },
          created_by: {
            type: 'keyword'
          },
          bump_agent_policy_revision: {
            type: 'boolean'
          },
          latest_revision: {
            type: 'boolean'
          }
        }
      },
      modelVersions: {
        '1': {
          changes: [{
            type: 'data_backfill',
            backfillFn: _security_solution.migratePackagePolicyToV8100
          }, {
            type: 'data_backfill',
            backfillFn: _to_v8_10_2.migrateSyntheticsPackagePolicyToV8100
          }],
          schemas: {
            forwardCompatibility: _to_v8_10_3.migratePackagePolicyEvictionsFromV8100
          }
        },
        '2': {
          changes: [{
            type: 'data_backfill',
            backfillFn: _to_v8_11_.migratePackagePolicyToV8110
          }],
          schemas: {
            forwardCompatibility: _to_v8_11_.migratePackagePolicyEvictionsFromV8110
          }
        },
        '3': {
          changes: [{
            type: 'data_backfill',
            backfillFn: _to_v8_11_0_.migratePackagePolicyToV81102
          }],
          schemas: {
            forwardCompatibility: _to_v8_11_0_.migratePackagePolicyEvictionsFromV81102
          }
        },
        '4': {
          changes: [{
            type: 'data_backfill',
            backfillFn: _cloud_security_posture.migrateCspPackagePolicyToV8110
          }]
        },
        '5': {
          changes: [{
            type: 'data_backfill',
            backfillFn: _to_v8_12_.migrateSyntheticsPackagePolicyToV8120
          }]
        },
        '6': {
          changes: [{
            type: 'data_backfill',
            backfillFn: _security_solution.migratePackagePolicyToV8140
          }]
        },
        '7': {
          changes: [{
            type: 'data_backfill',
            backfillFn: _security_solution.migratePackagePolicyEnableCapsToV8140
          }]
        },
        '8': {
          changes: [{
            type: 'data_backfill',
            backfillFn: _security_solution.migratePackagePolicyAddAntivirusRegistrationModeToV8140
          }]
        },
        '9': {
          changes: [{
            type: 'mappings_addition',
            addedMappings: {
              overrides: {
                type: 'flattened',
                index: false
              }
            }
          }]
        },
        '10': {
          changes: [{
            type: 'data_backfill',
            backfillFn: _security_solution2.packagePolicyV10OnWriteScanFix
          }]
        },
        '11': {
          changes: [{
            type: 'mappings_addition',
            addedMappings: {
              policy_ids: {
                type: 'keyword'
              }
            }
          }, {
            type: 'data_backfill',
            backfillFn: _to_v8_15_.migratePackagePolicySetRequiresRootToV8150
          }]
        },
        '12': {
          changes: [{
            type: 'mappings_addition',
            addedMappings: {
              package: {
                properties: {
                  requires_root: {
                    type: 'boolean'
                  }
                }
              }
            }
          }, {
            type: 'data_backfill',
            backfillFn: _to_v8_15_.migratePackagePolicyIdsToV8150
          }]
        },
        '13': {
          changes: [{
            type: 'data_backfill',
            backfillFn: _security_solution2.packagePolicyV13AdvancedFields
          }]
        },
        '14': {
          changes: [{
            type: 'mappings_addition',
            addedMappings: {
              output_id: {
                type: 'keyword'
              }
            }
          }]
        },
        '15': {
          changes: [{
            type: 'mappings_addition',
            addedMappings: {
              bump_agent_policy_revision: {
                type: 'boolean'
              }
            }
          }]
        },
        '16': {
          changes: [{
            type: 'mappings_addition',
            addedMappings: {
              supports_agentless: {
                type: 'boolean'
              }
            }
          }]
        },
        '17': {
          changes: [{
            type: 'data_backfill',
            backfillFn: _v17_advanced_package_policy_fields.packagePolicyV17AdvancedFieldsForEndpointV818
          }]
        },
        '18': {
          changes: [{
            type: 'mappings_addition',
            addedMappings: {} // Empty to add dynamic:false
          }]
        },
        '19': {
          changes: [{
            type: 'mappings_addition',
            addedMappings: {
              latest_revision: {
                type: 'boolean'
              }
            }
          }, {
            type: 'data_backfill',
            backfillFn: _package_policy_latest_revision_backfill.backfillPackagePolicyLatestRevision
          }]
        },
        '20': {
          changes: [{
            type: 'unsafe_transform',
            transformFn: typeSafeGuard => typeSafeGuard(_synthetics_disable_browser_input.disableBrowserInputWhenBothEnabled)
          }]
        }
      },
      migrations: {
        '7.10.0': _to_v7_10_.migratePackagePolicyToV7100,
        '7.11.0': _to_v7_11_.migratePackagePolicyToV7110,
        '7.12.0': _to_v7_12_.migratePackagePolicyToV7120,
        '7.13.0': _to_v7_13_.migratePackagePolicyToV7130,
        '7.14.0': _to_v7_14_.migratePackagePolicyToV7140,
        '7.15.0': _to_v7_15_.migratePackagePolicyToV7150,
        '7.16.0': _to_v7_16_.migratePackagePolicyToV7160,
        '8.2.0': _to_v8_2_.migratePackagePolicyToV820,
        '8.3.0': _to_v8_3_.migratePackagePolicyToV830,
        '8.4.0': _to_v8_4_.migratePackagePolicyToV840,
        '8.5.0': _to_v8_5_.migratePackagePolicyToV850,
        '8.6.0': _to_v8_6_.migratePackagePolicyToV860,
        '8.7.0': _security_solution.migratePackagePolicyToV870,
        '8.8.0': _to_v8_8_.migratePackagePolicyToV880
      }
    },
    [_constants.PACKAGE_POLICY_SAVED_OBJECT_TYPE]: {
      name: _constants.PACKAGE_POLICY_SAVED_OBJECT_TYPE,
      indexPattern: _constants2.INGEST_SAVED_OBJECT_INDEX,
      hidden: false,
      namespaceType: 'multiple',
      management: {
        importableAndExportable: false
      },
      mappings: {
        dynamic: false,
        properties: {
          name: {
            type: 'keyword'
          },
          description: {
            type: 'text'
          },
          namespace: {
            type: 'keyword'
          },
          enabled: {
            type: 'boolean'
          },
          is_managed: {
            type: 'boolean'
          },
          policy_id: {
            type: 'keyword'
          },
          policy_ids: {
            type: 'keyword'
          },
          output_id: {
            type: 'keyword'
          },
          package: {
            properties: {
              name: {
                type: 'keyword'
              },
              title: {
                type: 'keyword'
              },
              version: {
                type: 'keyword'
              },
              requires_root: {
                type: 'boolean'
              }
            }
          },
          elasticsearch: {
            dynamic: false,
            properties: {}
          },
          vars: {
            type: 'flattened'
          },
          inputs: {
            dynamic: false,
            properties: {}
          },
          secret_references: {
            properties: {
              id: {
                type: 'keyword'
              }
            }
          },
          overrides: {
            type: 'flattened',
            index: false
          },
          supports_agentless: {
            type: 'boolean'
          },
          revision: {
            type: 'integer'
          },
          updated_at: {
            type: 'date'
          },
          updated_by: {
            type: 'keyword'
          },
          created_at: {
            type: 'date'
          },
          created_by: {
            type: 'keyword'
          },
          bump_agent_policy_revision: {
            type: 'boolean'
          },
          latest_revision: {
            type: 'boolean'
          }
        }
      },
      modelVersions: {
        '1': {
          changes: [{
            type: 'mappings_addition',
            addedMappings: {
              bump_agent_policy_revision: {
                type: 'boolean'
              }
            }
          }]
        },
        '2': {
          changes: [{
            type: 'mappings_addition',
            addedMappings: {
              supports_agentless: {
                type: 'boolean'
              }
            }
          }]
        },
        '3': {
          changes: [{
            type: 'data_backfill',
            backfillFn: _v17_advanced_package_policy_fields.packagePolicyV17AdvancedFieldsForEndpointV818
          }]
        },
        '4': {
          changes: [{
            type: 'mappings_addition',
            addedMappings: {} // Empty to add dynamic:false
          }]
        },
        '5': {
          changes: [{
            type: 'mappings_addition',
            addedMappings: {
              latest_revision: {
                type: 'boolean'
              }
            }
          }, {
            type: 'data_backfill',
            backfillFn: _package_policy_latest_revision_backfill.backfillPackagePolicyLatestRevision
          }]
        },
        '6': {
          changes: [{
            type: 'unsafe_transform',
            transformFn: typeSafeGuard => typeSafeGuard(_synthetics_disable_browser_input.disableBrowserInputWhenBothEnabled)
          }]
        }
      }
    },
    [_constants2.PACKAGES_SAVED_OBJECT_TYPE]: {
      name: _constants2.PACKAGES_SAVED_OBJECT_TYPE,
      indexPattern: _constants2.INGEST_SAVED_OBJECT_INDEX,
      hidden: false,
      namespaceType: 'agnostic',
      management: {
        importableAndExportable: false
      },
      mappings: {
        dynamic: false,
        properties: {
          name: {
            type: 'keyword'
          },
          version: {
            type: 'keyword'
          },
          internal: {
            type: 'boolean'
          },
          keep_policies_up_to_date: {
            type: 'boolean',
            index: false
          },
          es_index_patterns: {
            dynamic: false,
            properties: {}
          },
          verification_status: {
            type: 'keyword'
          },
          verification_key_id: {
            type: 'keyword'
          },
          installed_es: {
            type: 'nested',
            properties: {
              id: {
                type: 'keyword'
              },
              type: {
                type: 'keyword'
              },
              version: {
                type: 'keyword'
              },
              deferred: {
                type: 'boolean'
              }
            }
          },
          latest_install_failed_attempts: {
            type: 'object',
            enabled: false
          },
          latest_executed_state: {
            type: 'object',
            enabled: false
          },
          installed_kibana: {
            dynamic: false,
            properties: {}
          },
          installed_kibana_space_id: {
            type: 'keyword'
          },
          package_assets: {
            dynamic: false,
            properties: {}
          },
          additional_spaces_installed_kibana: {
            type: 'flattened',
            index: false
          },
          install_started_at: {
            type: 'date'
          },
          install_version: {
            type: 'keyword'
          },
          install_status: {
            type: 'keyword'
          },
          install_source: {
            type: 'keyword'
          },
          install_format_schema_version: {
            type: 'version'
          },
          experimental_data_stream_features: {
            type: 'nested',
            properties: {
              data_stream: {
                type: 'keyword'
              },
              features: {
                type: 'nested',
                dynamic: false,
                properties: {
                  synthetic_source: {
                    type: 'boolean'
                  },
                  tsdb: {
                    type: 'boolean'
                  }
                }
              }
            }
          },
          previous_version: {
            type: 'keyword'
          }
        }
      },
      modelVersions: {
        '1': {
          changes: [{
            type: 'mappings_addition',
            addedMappings: {
              latest_install_failed_attempts: {
                type: 'object',
                enabled: false
              }
            }
          }]
        },
        '2': {
          changes: [{
            type: 'mappings_addition',
            addedMappings: {
              latest_executed_state: {
                type: 'object',
                enabled: false
              }
            }
          }]
        },
        '3': {
          changes: [{
            type: 'mappings_addition',
            addedMappings: {
              additional_spaces_installed_kibana: {
                type: 'flattened',
                index: false
              }
            }
          }]
        },
        '4': {
          changes: [{
            type: 'mappings_addition',
            addedMappings: {} // Empty to add dynamic:false
          }]
        },
        '5': {
          changes: [{
            type: 'mappings_addition',
            addedMappings: {
              previous_version: {
                type: 'keyword'
              }
            }
          }]
        }
      },
      migrations: {
        '7.14.0': _to_v7_14_.migrateInstallationToV7140,
        '7.14.1': _to_v7_14_.migrateInstallationToV7140,
        '7.16.0': _to_v7_16_.migrateInstallationToV7160,
        '8.0.0': _to_v8_0_.migrateInstallationToV800,
        '8.3.0': _to_v8_3_.migrateInstallationToV830,
        '8.4.0': _to_v8_4_.migrateInstallationToV840,
        '8.6.0': _to_v8_6_.migrateInstallationToV860
      }
    },
    [_constants2.ASSETS_SAVED_OBJECT_TYPE]: {
      name: _constants2.ASSETS_SAVED_OBJECT_TYPE,
      indexPattern: _constants2.INGEST_SAVED_OBJECT_INDEX,
      hidden: false,
      namespaceType: 'agnostic',
      management: {
        importableAndExportable: false
      },
      mappings: {
        properties: {
          package_name: {
            type: 'keyword'
          },
          package_version: {
            type: 'keyword'
          },
          install_source: {
            type: 'keyword'
          },
          asset_path: {
            type: 'keyword'
          },
          media_type: {
            type: 'keyword'
          },
          data_utf8: {
            type: 'text',
            index: false
          },
          data_base64: {
            type: 'binary'
          }
        }
      }
    },
    [_constants2.PRECONFIGURATION_DELETION_RECORD_SAVED_OBJECT_TYPE]: {
      name: _constants2.PRECONFIGURATION_DELETION_RECORD_SAVED_OBJECT_TYPE,
      indexPattern: _constants2.INGEST_SAVED_OBJECT_INDEX,
      hidden: false,
      namespaceType: useSpaceAwareness ? 'single' : 'agnostic',
      management: {
        importableAndExportable: false
      },
      mappings: {
        properties: {
          id: {
            type: 'keyword'
          }
        }
      }
    },
    [_constants2.DOWNLOAD_SOURCE_SAVED_OBJECT_TYPE]: {
      name: _constants2.DOWNLOAD_SOURCE_SAVED_OBJECT_TYPE,
      indexPattern: _constants2.INGEST_SAVED_OBJECT_INDEX,
      hidden: false,
      namespaceType: 'agnostic',
      management: {
        importableAndExportable: false
      },
      mappings: {
        dynamic: false,
        properties: {
          source_id: {
            type: 'keyword',
            index: false
          },
          name: {
            type: 'keyword'
          },
          is_default: {
            type: 'boolean'
          },
          host: {
            type: 'keyword'
          },
          proxy_id: {
            type: 'keyword'
          }
        }
      },
      modelVersions: {
        '1': {
          changes: [{
            type: 'mappings_addition',
            addedMappings: {}
          }]
        }
      }
    },
    [_constants2.FLEET_SERVER_HOST_SAVED_OBJECT_TYPE]: {
      name: _constants2.FLEET_SERVER_HOST_SAVED_OBJECT_TYPE,
      indexPattern: _constants2.INGEST_SAVED_OBJECT_INDEX,
      hidden: false,
      namespaceType: 'agnostic',
      management: {
        importableAndExportable: false
      },
      mappings: {
        dynamic: false,
        properties: {
          name: {
            type: 'keyword'
          },
          is_default: {
            type: 'boolean'
          },
          is_internal: {
            type: 'boolean',
            index: false
          },
          host_urls: {
            type: 'keyword',
            index: false
          },
          is_preconfigured: {
            type: 'boolean'
          },
          proxy_id: {
            type: 'keyword'
          }
        }
      },
      modelVersions: {
        '1': {
          changes: [{
            type: 'mappings_addition',
            addedMappings: {
              is_internal: {
                type: 'boolean',
                index: false
              }
            }
          }]
        },
        '2': {
          changes: [{
            type: 'mappings_addition',
            addedMappings: {}
          }]
        }
      }
    },
    [_constants2.FLEET_PROXY_SAVED_OBJECT_TYPE]: {
      name: _constants2.FLEET_PROXY_SAVED_OBJECT_TYPE,
      indexPattern: _constants2.INGEST_SAVED_OBJECT_INDEX,
      hidden: false,
      namespaceType: 'agnostic',
      management: {
        importableAndExportable: false
      },
      mappings: {
        properties: {
          name: {
            type: 'keyword'
          },
          url: {
            type: 'keyword',
            index: false
          },
          proxy_headers: {
            type: 'text',
            index: false
          },
          certificate_authorities: {
            type: 'keyword',
            index: false
          },
          certificate: {
            type: 'keyword',
            index: false
          },
          certificate_key: {
            type: 'keyword',
            index: false
          },
          is_preconfigured: {
            type: 'boolean'
          }
        }
      }
    },
    [_constants2.MESSAGE_SIGNING_KEYS_SAVED_OBJECT_TYPE]: {
      name: _constants2.MESSAGE_SIGNING_KEYS_SAVED_OBJECT_TYPE,
      indexPattern: _constants2.INGEST_SAVED_OBJECT_INDEX,
      hidden: true,
      namespaceType: 'agnostic',
      management: {
        importableAndExportable: false
      },
      mappings: {
        dynamic: false,
        properties: {}
      }
    },
    [_constants2.UNINSTALL_TOKENS_SAVED_OBJECT_TYPE]: {
      name: _constants2.UNINSTALL_TOKENS_SAVED_OBJECT_TYPE,
      indexPattern: _constants2.INGEST_SAVED_OBJECT_INDEX,
      hidden: true,
      namespaceType: 'agnostic',
      management: {
        importableAndExportable: false
      },
      mappings: {
        dynamic: false,
        properties: {
          policy_id: {
            type: 'keyword'
          },
          token_plain: {
            type: 'keyword'
          },
          namespaces: {
            type: 'keyword'
          }
        }
      },
      modelVersions: {
        '1': {
          changes: [{
            type: 'mappings_addition',
            addedMappings: {
              namespaces: {
                type: 'keyword'
              }
            }
          }]
        }
      }
    }
  };
};
exports.getSavedObjectTypes = getSavedObjectTypes;
function registerSavedObjects(savedObjects, options = {
  useSpaceAwareness: false
}) {
  const savedObjectTypes = getSavedObjectTypes({
    useSpaceAwareness: options.useSpaceAwareness
  });
  Object.values(savedObjectTypes).forEach(type => {
    savedObjects.registerType(type);
  });
}
const OUTPUT_INCLUDE_AAD_FIELDS = exports.OUTPUT_INCLUDE_AAD_FIELDS = new Set(['service_token', 'shipper', 'allow_edit', 'broker_ack_reliability', 'broker_buffer_size', 'channel_buffer_size']);

// dangerouslyExposeValue added to allow the user with access to the SO to see and edit these values through the UI
const OUTPUT_ENCRYPTED_FIELDS = exports.OUTPUT_ENCRYPTED_FIELDS = new Set([{
  key: 'ssl',
  dangerouslyExposeValue: true
}, {
  key: 'password',
  dangerouslyExposeValue: true
}, {
  key: 'kibana_api_key',
  dangerouslyExposeValue: true
}]);
const FLEET_SERVER_HOST_ENCRYPTED_FIELDS = exports.FLEET_SERVER_HOST_ENCRYPTED_FIELDS = new Set([{
  key: 'ssl',
  dangerouslyExposeValue: true
}]);
function registerEncryptedSavedObjects(encryptedSavedObjects) {
  encryptedSavedObjects.registerType({
    type: _constants2.OUTPUT_SAVED_OBJECT_TYPE,
    attributesToEncrypt: OUTPUT_ENCRYPTED_FIELDS,
    attributesToIncludeInAAD: OUTPUT_INCLUDE_AAD_FIELDS
  });
  // Encrypted saved objects
  encryptedSavedObjects.registerType({
    type: _constants2.MESSAGE_SIGNING_KEYS_SAVED_OBJECT_TYPE,
    attributesToEncrypt: new Set(['passphrase']),
    attributesToIncludeInAAD: new Set(['private_key', 'public_key', 'passphrase_plain'])
  });
  encryptedSavedObjects.registerType({
    type: _constants2.UNINSTALL_TOKENS_SAVED_OBJECT_TYPE,
    attributesToEncrypt: new Set(['token']),
    attributesToIncludeInAAD: new Set(['policy_id', 'token_plain'])
  });
  encryptedSavedObjects.registerType({
    type: _constants2.FLEET_SERVER_HOST_SAVED_OBJECT_TYPE,
    attributesToEncrypt: FLEET_SERVER_HOST_ENCRYPTED_FIELDS,
    // enforceRandomId allows to create an SO with an arbitrary id
    enforceRandomId: false
  });
  encryptedSavedObjects.registerType({
    type: _constants2.DOWNLOAD_SOURCE_SAVED_OBJECT_TYPE,
    attributesToEncrypt: new Set([{
      key: 'ssl',
      dangerouslyExposeValue: true
    }]),
    // enforceRandomId allows to create an SO with an arbitrary id
    enforceRandomId: false
  });
}