"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.notFoundResponse = exports.internalErrorResponse = exports.genericErrorResponse = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const genericErrorResponse = () => _configSchema.schema.object({
  statusCode: _configSchema.schema.maybe(_configSchema.schema.number()),
  error: _configSchema.schema.maybe(_configSchema.schema.string()),
  errorType: _configSchema.schema.maybe(_configSchema.schema.string()),
  message: _configSchema.schema.string(),
  attributes: _configSchema.schema.maybe(_configSchema.schema.any())
}, {
  meta: {
    description: 'Generic Error'
  }
});
exports.genericErrorResponse = genericErrorResponse;
const notFoundResponse = () => _configSchema.schema.object({
  message: _configSchema.schema.string()
});
exports.notFoundResponse = notFoundResponse;
const internalErrorResponse = () => _configSchema.schema.object({
  message: _configSchema.schema.string()
}, {
  meta: {
    description: 'Internal Server Error'
  }
});
exports.internalErrorResponse = internalErrorResponse;