"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIntegrationsDetails = void 0;
var _constants = require("../constants");
var _services = require("../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getIntegrationsDetails = async soClient => {
  if (!soClient) {
    return [];
  }
  const allPackagePolicies = await _services.packagePolicyService.list(soClient, {
    perPage: _constants.SO_SEARCH_LIMIT
  });
  const sharedPackagePolicies = allPackagePolicies.items.filter(packagePolicy => {
    var _packagePolicy$policy;
    if ((packagePolicy === null || packagePolicy === void 0 ? void 0 : (_packagePolicy$policy = packagePolicy.policy_ids) === null || _packagePolicy$policy === void 0 ? void 0 : _packagePolicy$policy.length) > 1) return packagePolicy;
  });
  const integrationsDetails = (sharedPackagePolicies || []).map(packagePolicy => {
    var _packagePolicy$packag, _packagePolicy$packag2;
    return {
      total_integration_policies: allPackagePolicies.items.length,
      shared_integration_policies: sharedPackagePolicies.length,
      shared_integrations: {
        name: packagePolicy.name,
        pkg_name: (_packagePolicy$packag = packagePolicy.package) === null || _packagePolicy$packag === void 0 ? void 0 : _packagePolicy$packag.name,
        pkg_version: (_packagePolicy$packag2 = packagePolicy.package) === null || _packagePolicy$packag2 === void 0 ? void 0 : _packagePolicy$packag2.version,
        shared_by_agent_policies: packagePolicy === null || packagePolicy === void 0 ? void 0 : packagePolicy.policy_ids.length,
        agents: packagePolicy === null || packagePolicy === void 0 ? void 0 : packagePolicy.agents
      }
    };
  });
  return integrationsDetails;
};
exports.getIntegrationsDetails = getIntegrationsDetails;