"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAgentsPerOutput = getAgentsPerOutput;
var _lodash = _interopRequireDefault(require("lodash"));
var _output_helpers = require("../../common/services/output_helpers");
var _common = require("../../common");
var _services = require("../services");
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getAgentsPerOutput(soClient, esClient) {
  var _outputs$find, _outputs$find2;
  const {
    items: outputs
  } = await _services.outputService.list(soClient);
  const defaultOutputId = ((_outputs$find = outputs.find(output => output.is_default)) === null || _outputs$find === void 0 ? void 0 : _outputs$find.id) || '';
  const defaultMonitoringOutputId = ((_outputs$find2 = outputs.find(output => output.is_default_monitoring)) === null || _outputs$find2 === void 0 ? void 0 : _outputs$find2.id) || '';
  const outputsById = _lodash.default.keyBy(outputs, 'id');
  const getDataOutputForAgentPolicy = agentPolicy => outputsById[agentPolicy.data_output_id || defaultOutputId];
  const getMonitoringOutputForAgentPolicy = agentPolicy => outputsById[agentPolicy.monitoring_output_id || defaultMonitoringOutputId];
  const {
    items: agentPolicies
  } = await _services.agentPolicyService.list(soClient, {
    esClient,
    page: 1,
    perPage: _common.SO_SEARCH_LIMIT,
    withAgentCount: true
  });
  const outputTypes = {};
  agentPolicies.filter(agentPolicy => {
    var _agentPolicy$agents;
    return ((_agentPolicy$agents = agentPolicy.agents) !== null && _agentPolicy$agents !== void 0 ? _agentPolicy$agents : 0) > 0;
  }).forEach(agentPolicy => {
    var _agentPolicy$agents2, _agentPolicy$agents3;
    const dataOutput = getDataOutputForAgentPolicy(agentPolicy);
    const monitoringOutput = getMonitoringOutputForAgentPolicy(agentPolicy);
    if (!outputTypes[dataOutput.type]) {
      outputTypes[dataOutput.type] = {
        output_type: dataOutput.type,
        count_as_data: 0,
        count_as_monitoring: 0
      };
    }
    outputTypes[dataOutput.type].count_as_data += (_agentPolicy$agents2 = agentPolicy.agents) !== null && _agentPolicy$agents2 !== void 0 ? _agentPolicy$agents2 : 0;
    if (!outputTypes[monitoringOutput.type]) {
      outputTypes[monitoringOutput.type] = {
        output_type: monitoringOutput.type,
        count_as_data: 0,
        count_as_monitoring: 0
      };
    }
    outputTypes[monitoringOutput.type].count_as_monitoring += (_agentPolicy$agents3 = agentPolicy.agents) !== null && _agentPolicy$agents3 !== void 0 ? _agentPolicy$agents3 : 0;
  });
  outputs.forEach(output => {
    if (!(0, _output_helpers.outputTypeSupportPresets)(output.type)) {
      return;
    }
    if (!outputTypes[output.type]) {
      return;
    }
    const outputTelemetryRecord = outputTypes[output.type];
    if (!outputTelemetryRecord.preset_counts) {
      outputTelemetryRecord.preset_counts = {
        balanced: 0,
        custom: 0,
        latency: 0,
        scale: 0,
        throughput: 0
      };
    }
    if (output.preset && output.preset in outputTelemetryRecord.preset_counts) {
      outputTelemetryRecord.preset_counts[output.preset] += 1;
    }
    if (output.type === _constants.outputType.RemoteElasticsearch && output.sync_integrations) {
      outputTelemetryRecord.sync_integrations = output.sync_integrations;
    }
  });
  return Object.values(outputTypes);
}