"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PackagePolicyDeleteProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _reactRouterDom = require("react-router-dom");
var _hooks = require("../hooks");
var _constants = require("../../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PackagePolicyDeleteProvider = ({
  agentPolicies,
  from,
  children,
  packagePolicyPackage
}) => {
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const {
    agents: {
      enabled: isFleetEnabled
    }
  } = (0, _hooks.useConfig)();
  const history = (0, _reactRouterDom.useHistory)();
  const {
    getPath
  } = (0, _hooks.useLink)();
  const [packagePolicies, setPackagePolicies] = (0, _react.useState)([]);
  const [isModalOpen, setIsModalOpen] = (0, _react.useState)(false);
  const [isLoadingAgentsCount, setIsLoadingAgentsCount] = (0, _react.useState)(false);
  const [agentsCount, setAgentsCount] = (0, _react.useState)(0);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const onSuccessCallback = (0, _react.useRef)(null);
  const {
    canUseMultipleAgentPolicies
  } = (0, _hooks.useMultipleAgentPolicies)();
  const {
    mutateAsync: deletePackagePolicyMutationAsync
  } = (0, _hooks.useDeletePackagePolicyMutation)();
  const isShared = (0, _react.useMemo)(() => {
    var _agentPolicies$0$pack, _packagePolicy$policy, _packagePolicy$policy2;
    if ((agentPolicies === null || agentPolicies === void 0 ? void 0 : agentPolicies.length) !== 1) {
      return false;
    }
    const packagePolicy = (_agentPolicies$0$pack = agentPolicies[0].package_policies) === null || _agentPolicies$0$pack === void 0 ? void 0 : _agentPolicies$0$pack.find(policy => policy.id === packagePolicies[0]);
    return ((_packagePolicy$policy = packagePolicy === null || packagePolicy === void 0 ? void 0 : (_packagePolicy$policy2 = packagePolicy.policy_ids) === null || _packagePolicy$policy2 === void 0 ? void 0 : _packagePolicy$policy2.length) !== null && _packagePolicy$policy !== void 0 ? _packagePolicy$policy : 0) > 1;
  }, [agentPolicies, packagePolicies]);
  const hasMultipleAgentPolicies = canUseMultipleAgentPolicies && agentPolicies && agentPolicies.length > 1;
  const fetchAgentsCount = (0, _react.useMemo)(() => async () => {
    var _request$data;
    if (isLoadingAgentsCount || !isFleetEnabled || !agentPolicies) {
      return;
    }
    setIsLoadingAgentsCount(true);
    const kuery = `(${agentPolicies.map(policy => `${_constants.AGENTS_PREFIX}.policy_id:"${policy.id}"`).join(' or ')})`;
    const request = await (0, _hooks.sendGetAgents)({
      kuery,
      showInactive: true
    });
    setAgentsCount(((_request$data = request.data) === null || _request$data === void 0 ? void 0 : _request$data.total) || 0);
    setIsLoadingAgentsCount(false);
  }, [agentPolicies, isFleetEnabled, isLoadingAgentsCount]);
  const deletePackagePoliciesPrompt = (0, _react.useMemo)(() => (packagePoliciesToDelete, onSuccess = () => undefined) => {
    if (!Array.isArray(packagePoliciesToDelete) || packagePoliciesToDelete.length === 0) {
      throw new Error('No package policies specified for deletion');
    }
    setIsModalOpen(true);
    setPackagePolicies(packagePoliciesToDelete);
    fetchAgentsCount();
    onSuccessCallback.current = onSuccess;
  }, [fetchAgentsCount]);
  const closeModal = (0, _react.useMemo)(() => () => {
    setPackagePolicies([]);
    setIsLoading(false);
    setIsLoadingAgentsCount(false);
    setIsModalOpen(false);
  }, []);
  const agentPoliciesNamesList = (0, _react.useMemo)(() => agentPolicies === null || agentPolicies === void 0 ? void 0 : agentPolicies.map(p => p.name).join(', '), [agentPolicies]);
  const deletePackagePolicies = (0, _react.useCallback)(async () => {
    setIsLoading(true);
    try {
      /**
       * Try to delete assets if there are any
       */
      if ((packagePolicyPackage === null || packagePolicyPackage === void 0 ? void 0 : packagePolicyPackage.type) === 'input') {
        var _assetsData$error;
        const assetsData = await (0, _hooks.sendDeletePackageDatastreamAssets)({
          pkgName: packagePolicyPackage === null || packagePolicyPackage === void 0 ? void 0 : packagePolicyPackage.name,
          pkgVersion: packagePolicyPackage === null || packagePolicyPackage === void 0 ? void 0 : packagePolicyPackage.version
        }, {
          packagePolicyId: packagePolicies[0]
        });
        if (assetsData !== null && assetsData !== void 0 && (_assetsData$error = assetsData.error) !== null && _assetsData$error !== void 0 && _assetsData$error.message) {
          notifications.toasts.addDanger(`Error: ${assetsData.error.message}`);
        }
      }
      const data = await deletePackagePolicyMutationAsync({
        packagePolicyIds: packagePolicies
      });
      const successfulResults = (data === null || data === void 0 ? void 0 : data.filter(result => result.success)) || [];
      const failedResults = (data === null || data === void 0 ? void 0 : data.filter(result => !result.success)) || [];
      if (successfulResults.length) {
        const hasMultipleSuccesses = successfulResults.length > 1;
        const successMessage = hasMultipleSuccesses ? _i18n.i18n.translate('xpack.fleet.deletePackagePolicy.successMultipleNotificationTitle', {
          defaultMessage: 'Deleted {count} integrations',
          values: {
            count: successfulResults.length
          }
        }) : _i18n.i18n.translate('xpack.fleet.deletePackagePolicy.successSingleNotificationTitle', {
          defaultMessage: "Deleted integration ''{id}''",
          values: {
            id: successfulResults[0].name || successfulResults[0].id
          }
        });
        const agentlessPolicy = agentPolicies === null || agentPolicies === void 0 ? void 0 : agentPolicies.find(policy => policy.supports_agentless === true);
        if (!!agentlessPolicy) {
          try {
            await (0, _hooks.sendDeleteAgentPolicy)({
              agentPolicyId: agentlessPolicy.id
            });
            if (from === 'fleet-policy-list') {
              history.push(getPath('policies_list'));
            }
          } catch (e) {
            notifications.toasts.addDanger(_i18n.i18n.translate('xpack.fleet.deletePackagePolicy.fatalErrorAgentlessNotificationTitle', {
              defaultMessage: 'Error deleting agentless deployment'
            }));
          }
        }
        notifications.toasts.addSuccess(successMessage);
      }
      if (failedResults.length) {
        const hasMultipleFailures = failedResults.length > 1;
        const failureMessage = hasMultipleFailures ? _i18n.i18n.translate('xpack.fleet.deletePackagePolicy.failureMultipleNotificationTitle', {
          defaultMessage: 'Error deleting {count} integrations',
          values: {
            count: failedResults.length
          }
        }) : _i18n.i18n.translate('xpack.fleet.deletePackagePolicy.failureSingleNotificationTitle', {
          defaultMessage: "Error deleting integration ''{id}''",
          values: {
            id: failedResults[0].id
          }
        });
        notifications.toasts.addDanger(failureMessage);
      }
      if (onSuccessCallback.current) {
        onSuccessCallback.current(successfulResults.map(result => result.id));
      }
    } catch (e) {
      notifications.toasts.addDanger(_i18n.i18n.translate('xpack.fleet.deletePackagePolicy.fatalErrorNotificationTitle', {
        defaultMessage: `Error deleting integration`
      }));
    }
    closeModal();
  }, [packagePolicies, closeModal, deletePackagePolicyMutationAsync, packagePolicyPackage, agentPolicies, notifications.toasts, from, history, getPath]);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const renderModal = () => {
    var _agentPolicies$, _agentPolicies$$packa, _agentPolicies$2;
    const isAgentlessPolicy = agentPolicies === null || agentPolicies === void 0 ? void 0 : agentPolicies.find(policy => (policy === null || policy === void 0 ? void 0 : policy.supports_agentless) === true);
    const packagePolicy = agentPolicies === null || agentPolicies === void 0 ? void 0 : (_agentPolicies$ = agentPolicies[0]) === null || _agentPolicies$ === void 0 ? void 0 : (_agentPolicies$$packa = _agentPolicies$.package_policies) === null || _agentPolicies$$packa === void 0 ? void 0 : _agentPolicies$$packa.find(policy => policy.id === packagePolicies[0]);
    if (!isModalOpen) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
      "aria-labelledby": modalTitleId,
      titleProps: {
        id: modalTitleId
      },
      title: isAgentlessPolicy ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.deletePackagePolicy.confirmModal.agentlessTitle",
        defaultMessage: "You\u2019re about to delete an integration"
      }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.deletePackagePolicy.confirmModal.deleteMultipleTitle",
        defaultMessage: "Delete {count, plural, one {integration} other {# integrations}}?",
        values: {
          count: packagePolicies.length
        }
      }),
      onCancel: closeModal,
      onConfirm: deletePackagePolicies,
      cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.deletePackagePolicy.confirmModal.cancelButtonLabel",
        defaultMessage: "Cancel"
      }),
      confirmButtonText: isLoading || isLoadingAgentsCount ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.deletePackagePolicy.confirmModal.loadingButtonLabel",
        defaultMessage: "Loading\u2026"
      }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.deletePackagePolicy.confirmModal.confirmButtonLabel",
        defaultMessage: "Delete {agentPoliciesCount, plural, one {integration} other {integrations}}",
        values: {
          agentPoliciesCount: packagePolicies.length
        }
      }),
      buttonColor: "danger",
      confirmButtonDisabled: isLoading || isLoadingAgentsCount
    }, (packagePolicyPackage === null || packagePolicyPackage === void 0 ? void 0 : packagePolicyPackage.type) === 'input' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "warning",
      iconType: "alert",
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.deletePackagePolicy.confirmModal.inputPackage.message",
        defaultMessage: "This action will also remove the installed assets"
      }),
      "data-test-subj": "InputPackageCallOut"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    })), (hasMultipleAgentPolicies || isShared) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "warning",
      iconType: "alert",
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.deletePackagePolicy.confirmModal.warningMultipleAgentPolicies",
        defaultMessage: "This integration is shared by multiple agent policies."
      }),
      "data-test-subj": "sharedAgentPolicyCallOut"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    })), isLoadingAgentsCount ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.deletePackagePolicy.confirmModal.loadingAgentsCountMessage",
      defaultMessage: "Checking affected agents\u2026"
    }) : agentsCount && agentPolicies ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "danger",
      "data-test-subj": "affectedAgentsCallOut",
      title: !isAgentlessPolicy && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.deletePackagePolicy.confirmModal.affectedAgentsTitle",
        defaultMessage: "This action will affect {agentsCount} {agentsCount, plural, one {agent} other {agents}}.",
        values: {
          agentsCount
        }
      })
    }, hasMultipleAgentPolicies && !isAgentlessPolicy && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.deletePackagePolicy.confirmModal.affectedAgentPoliciesMessage",
      defaultMessage: "Fleet has detected that the related agent policies {toolTip} are already in use by some of your agents.",
      values: {
        toolTip: /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
          type: "info",
          iconProps: {
            className: 'eui-alignTop'
          },
          content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.fleet.fleetServerSetup.affectedAgentsMessageTooltips",
            defaultMessage: "{policies}",
            values: {
              policies: agentPoliciesNamesList
            }
          }),
          position: "top"
        })
      }
    }), ' ', !hasMultipleAgentPolicies && !isAgentlessPolicy && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.deletePackagePolicy.confirmModal.affectedAgentsMessage",
      defaultMessage: "Fleet has detected that {agentPolicyName} is already in use by some of your agents.",
      values: {
        agentPolicyName: /*#__PURE__*/_react.default.createElement("strong", null, (_agentPolicies$2 = agentPolicies[0]) === null || _agentPolicies$2 === void 0 ? void 0 : _agentPolicies$2.name)
      }
    }), !hasMultipleAgentPolicies && isAgentlessPolicy && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.deletePackagePolicy.agentless.confirmModal.message",
      defaultMessage: "Deleting {packagePolicyName} integration will stop data ingestion.",
      values: {
        packagePolicyName: /*#__PURE__*/_react.default.createElement("strong", null, packagePolicy === null || packagePolicy === void 0 ? void 0 : packagePolicy.name)
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    })) : null, !isLoadingAgentsCount && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.deletePackagePolicy.confirmModal.generalMessage",
      defaultMessage: "This action can not be undone. Are you sure you wish to continue?"
    }));
  };
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, children(deletePackagePoliciesPrompt), renderModal());
};
exports.PackagePolicyDeleteProvider = PackagePolicyDeleteProvider;