"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PackagePoliciesPanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _hooks = require("../../../../../hooks");
var _package_icon = require("../../../../../../../components/package_icon");
var _policies = require("../../detail/policies");
var _use_url_filters = require("../hooks/use_url_filters");
var _resizable_panel = require("./resizable_panel");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PackagePoliciesPanel = ({
  installedPackage
}) => {
  const {
    addViewPolicies
  } = (0, _use_url_filters.useViewPolicies)();
  const paddingStyles = (0, _eui.useEuiPaddingCSS)();
  const cssStyles = [paddingStyles.s];
  const title = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_package_icon.TableIcon, {
    size: "m",
    icons: installedPackage.icons,
    packageName: installedPackage.name,
    version: installedPackage.version
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, installedPackage.title)));
  const content = /*#__PURE__*/_react.default.createElement("div", {
    css: cssStyles
  }, /*#__PURE__*/_react.default.createElement(_hooks.IntegrationsStateContextProvider, null, /*#__PURE__*/_react.default.createElement(_policies.PackagePoliciesPage, {
    embedded: true,
    packageInfo: installedPackage
  })));
  return /*#__PURE__*/_react.default.createElement(_resizable_panel.ResizablePanel, {
    title: title,
    content: content,
    onClose: () => addViewPolicies('')
  });
};
exports.PackagePoliciesPanel = PackagePoliciesPanel;