"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FleetServerOnPremRequiredCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _hooks = require("../../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FleetServerOnPremRequiredCallout = () => {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "warning",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.fleetServerOnPremRequiredCallout.calloutTitle",
      defaultMessage: "A Fleet Server is required before enrolling agents with Fleet."
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.fleetServerOnPremRequiredCallout.calloutDescription",
    defaultMessage: "Follow the instructions below to set up a Fleet Server. For more information, see the {guideLink}.",
    values: {
      guideLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.fleet.fleetServerAddFleetServer,
        target: "_blank",
        external: true
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.fleetServerOnPremRequiredCallout.guideLink",
        defaultMessage: "Fleet and Elastic Agent Guide"
      }))
    }
  }));
};
exports.FleetServerOnPremRequiredCallout = FleetServerOnPremRequiredCallout;