"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hasUpgradeAvailable = hasUpgradeAvailable;
var _gt = _interopRequireDefault(require("semver/functions/gt"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Given a dry run response, determines if a greater version exists in the "proposed"
 * version of the first package policy in the response.
 */
function hasUpgradeAvailable(dryRunData) {
  var _dryRunData$0$diff$1$, _dryRunData$0$diff$1$2, _dryRunData$0$diff$0$, _dryRunData$0$diff$0$2;
  return dryRunData && dryRunData[0].diff && (0, _gt.default)((_dryRunData$0$diff$1$ = (_dryRunData$0$diff$1$2 = dryRunData[0].diff[1].package) === null || _dryRunData$0$diff$1$2 === void 0 ? void 0 : _dryRunData$0$diff$1$2.version) !== null && _dryRunData$0$diff$1$ !== void 0 ? _dryRunData$0$diff$1$ : '', (_dryRunData$0$diff$0$ = (_dryRunData$0$diff$0$2 = dryRunData[0].diff[0].package) === null || _dryRunData$0$diff$0$2 === void 0 ? void 0 : _dryRunData$0$diff$0$2.version) !== null && _dryRunData$0$diff$0$ !== void 0 ? _dryRunData$0$diff$0$ : '');
}